/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;

public class PoolConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PoolConfiguration.class);
    private static PoolConfiguration poolConfiguration;
    private int maxActivePerPool = -1;
    private int minIdlePerPool;
    private int maxIdlePerPool = 100;
    private boolean testOnBorrow = true;
    private boolean testWhileIdle = true;
    private long timeBetweenEvictionRuns = 30000L;
    private long minEvictableIdleTime = 300000L;
    private byte exhaustedAction = (byte)2;
    private int numberOfPools = 0;
    private int executorServiceThreads = 20;

    private PoolConfiguration(Set<TransportProperty> transportPropertySet) {
        if (transportPropertySet != null && !transportPropertySet.isEmpty()) {
            for (TransportProperty transportProperty : transportPropertySet) {
                if (transportProperty.getName().equals("client.connection.pool.count")) {
                    this.numberOfPools = (Integer)transportProperty.getValue();
                    continue;
                }
                if (transportProperty.getName().equals("client.max.active.connections.per.pool")) {
                    this.maxActivePerPool = (Integer)transportProperty.getValue();
                    continue;
                }
                if (transportProperty.getName().equals("client.min.idle.connections.per.pool")) {
                    this.minIdlePerPool = (Integer)transportProperty.getValue();
                    continue;
                }
                if (transportProperty.getName().equals("cleint.max.idle.connections.per.pool")) {
                    this.maxIdlePerPool = (Integer)transportProperty.getValue();
                    continue;
                }
                if (transportProperty.getName().equals("client.min.eviction.idle.time")) {
                    this.minEvictableIdleTime = ((Integer)transportProperty.getValue()).intValue();
                    continue;
                }
                if (!transportProperty.getName().equals("sender.thread.count")) continue;
                this.executorServiceThreads = (Integer)transportProperty.getValue();
            }
        }
        logger.debug("client.connection.pool.count: " + this.numberOfPools);
        logger.debug("client.max.active.connections.per.pool:" + this.maxActivePerPool);
        logger.debug("client.min.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("cleint.max.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("client.min.eviction.idle.time:" + this.minEvictableIdleTime);
        logger.debug("sender.thread.count:" + this.executorServiceThreads);
        logger.debug("Time between Evictions Runs:" + this.timeBetweenEvictionRuns);
        logger.debug("Pool exhausted action:" + this.exhaustedAction);
    }

    public static PoolConfiguration getInstance() {
        return poolConfiguration;
    }

    public static void createPoolConfiguration(Set<TransportProperty> transportPropertySet) {
        poolConfiguration = new PoolConfiguration(transportPropertySet);
    }

    public int getMaxActivePerPool() {
        return this.maxActivePerPool;
    }

    public int getMinIdlePerPool() {
        return this.minIdlePerPool;
    }

    public int getMaxIdlePerPool() {
        return this.maxIdlePerPool;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public long getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public byte getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getNumberOfPools() {
        return this.numberOfPools;
    }

    public int getExecutorServiceThreads() {
        return this.executorServiceThreads;
    }
}

