/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;

public class PoolableTargetChannelFactoryPerSrcHndlr
implements PoolableObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(PoolableTargetChannelFactoryPerSrcHndlr.class);
    private final GenericObjectPool genericObjectPool;

    public PoolableTargetChannelFactoryPerSrcHndlr(GenericObjectPool genericObjectPool) {
        this.genericObjectPool = genericObjectPool;
    }

    @Override
    public Object makeObject() throws Exception {
        TargetChannel targetChannel = (TargetChannel)this.genericObjectPool.borrowObject();
        log.debug("Created channel: {}", (Object)targetChannel);
        return targetChannel;
    }

    @Override
    public void destroyObject(Object o) throws Exception {
        if (((TargetChannel)o).getChannel().isActive()) {
            this.genericObjectPool.returnObject(o);
        } else {
            this.genericObjectPool.invalidateObject(o);
        }
        log.debug("Destroying channel: {}", o);
    }

    @Override
    public boolean validateObject(Object o) {
        boolean answer = ((TargetChannel)o).getChannel().isActive();
        log.debug("Validating channel: {} -> {}", o, (Object)answer);
        return answer;
    }

    @Override
    public void activateObject(Object o) throws Exception {
    }

    @Override
    public void passivateObject(Object o) throws Exception {
    }
}

