/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.sender.channel.pool;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.wso2.transport.http.netty.common.HttpRoute;
import org.wso2.transport.http.netty.common.Util;
import org.wso2.transport.http.netty.config.SenderConfiguration;
import org.wso2.transport.http.netty.listener.SourceHandler;
import org.wso2.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.transport.http.netty.sender.channel.pool.PoolConfiguration;
import org.wso2.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactory;
import org.wso2.transport.http.netty.sender.channel.pool.PoolableTargetChannelFactoryPerSrcHndlr;

public class ConnectionManager {
    private EventLoopGroup clientEventGroup;
    private PoolConfiguration poolConfiguration;
    private PoolManagementPolicy poolManagementPolicy;
    private final Map<String, GenericObjectPool> connGlobalPool;
    private EventLoopGroup targetEventLoopGroup;
    private static volatile ConnectionManager connectionManager;

    private ConnectionManager(PoolConfiguration poolConfiguration, Map<String, Object> transportProperties) {
        this.poolConfiguration = poolConfiguration;
        if (poolConfiguration.getNumberOfPools() == 1) {
            this.poolManagementPolicy = PoolManagementPolicy.LOCK_DEFAULT_POOLING;
        }
        this.connGlobalPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.clientEventGroup = new NioEventLoopGroup(Util.getIntProperty(transportProperties, "client.bootstrap.worker.group.size", 4));
        this.targetEventLoopGroup = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2);
    }

    private GenericObjectPool createPoolForRoute(PoolableTargetChannelFactory poolableTargetChannelFactory) {
        return new GenericObjectPool((PoolableObjectFactory)poolableTargetChannelFactory, this.instantiateAndConfigureConfig());
    }

    private GenericObjectPool createPoolForRoutePerSrcHndlr(GenericObjectPool genericObjectPool) {
        return new GenericObjectPool((PoolableObjectFactory)new PoolableTargetChannelFactoryPerSrcHndlr(genericObjectPool), this.instantiateAndConfigureConfig());
    }

    public static ConnectionManager getInstance() {
        return connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Map<String, Object> transportProperties) {
        if (connectionManager != null) return;
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (connectionManager != null) return;
            PoolConfiguration poolConfiguration = PoolConfiguration.getInstance();
            if (poolConfiguration == null) {
                PoolConfiguration.createPoolConfiguration(transportProperties);
                poolConfiguration = PoolConfiguration.getInstance();
            }
            connectionManager = new ConnectionManager(poolConfiguration, transportProperties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetChannel borrowTargetChannel(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfiguration) throws Exception {
        GenericObjectPool trgHlrConnPool;
        if (sourceHandler != null) {
            ChannelHandlerContext ctx = sourceHandler.getInboundChannelContext();
            EventLoopGroup group = this.targetEventLoopGroup;
            Class<?> cl = ctx.channel().getClass();
            if (this.poolManagementPolicy == PoolManagementPolicy.LOCK_DEFAULT_POOLING) {
                Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                if (trgHlrConnPool == null) {
                    PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfiguration);
                    trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                    srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                }
            } else {
                Map<String, GenericObjectPool> srcHlrConnPool = sourceHandler.getTargetChannelPool();
                trgHlrConnPool = srcHlrConnPool.get(httpRoute.toString());
                if (trgHlrConnPool == null) {
                    ConnectionManager connectionManager = this;
                    synchronized (connectionManager) {
                        if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                            PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfiguration);
                            trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                            this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                        }
                        trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
                        trgHlrConnPool = this.createPoolForRoutePerSrcHndlr(trgHlrConnPool);
                    }
                    srcHlrConnPool.put(httpRoute.toString(), trgHlrConnPool);
                }
            }
        } else {
            Class<NioSocketChannel> cl = NioSocketChannel.class;
            EventLoopGroup group = this.clientEventGroup;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this.connGlobalPool.containsKey(httpRoute.toString())) {
                    PoolableTargetChannelFactory poolableTargetChannelFactory = new PoolableTargetChannelFactory(group, cl, httpRoute, senderConfiguration);
                    trgHlrConnPool = this.createPoolForRoute(poolableTargetChannelFactory);
                    this.connGlobalPool.put(httpRoute.toString(), trgHlrConnPool);
                }
                trgHlrConnPool = this.connGlobalPool.get(httpRoute.toString());
            }
        }
        TargetChannel targetChannel = (TargetChannel)trgHlrConnPool.borrowObject();
        targetChannel.setCorrelatedSource(sourceHandler);
        targetChannel.setConnectionManager(this);
        return targetChannel;
    }

    public void returnChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        if (targetChannel.getCorrelatedSource() != null) {
            Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
            this.releaseChannelToPool(targetChannel, objectPoolMap.get(targetChannel.getHttpRoute().toString()));
        }
    }

    private void releaseChannelToPool(TargetChannel targetChannel, GenericObjectPool pool) throws Exception {
        try {
            if (targetChannel.getChannel().isActive()) {
                pool.returnObject(targetChannel);
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot return channel to pool", e);
        }
    }

    public void invalidateTargetChannel(TargetChannel targetChannel) throws Exception {
        targetChannel.setRequestWritten(false);
        if (targetChannel.getCorrelatedSource() != null) {
            Map<String, GenericObjectPool> objectPoolMap = targetChannel.getCorrelatedSource().getTargetChannelPool();
            try {
                if (objectPoolMap.get(targetChannel.getHttpRoute().toString()) != null) {
                    objectPoolMap.get(targetChannel.getHttpRoute().toString()).invalidateObject(targetChannel);
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot invalidate channel from pool", e);
            }
        }
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.connGlobalPool;
    }

    private GenericObjectPool.Config instantiateAndConfigureConfig() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxActive = this.poolConfiguration.getMaxActivePerPool();
        config.maxIdle = this.poolConfiguration.getMaxIdlePerPool();
        config.minIdle = this.poolConfiguration.getMinIdlePerPool();
        config.testOnBorrow = this.poolConfiguration.isTestOnBorrow();
        config.testWhileIdle = this.poolConfiguration.isTestWhileIdle();
        config.timeBetweenEvictionRunsMillis = this.poolConfiguration.getTimeBetweenEvictionRuns();
        config.minEvictableIdleTimeMillis = this.poolConfiguration.getMinEvictableIdleTime();
        config.whenExhaustedAction = this.poolConfiguration.getExhaustedAction();
        config.maxWait = this.poolConfiguration.getMaxWait();
        return config;
    }

    public static enum PoolManagementPolicy {
        LOCK_DEFAULT_POOLING;

    }
}

