/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HttpBodyPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] content;
    private final String contentType;
    private final String partName;
    private final String fileName;
    private final int size;
    private Map<String, Object> headers = new HashMap<String, Object>();

    public HttpBodyPart(String partName, byte[] content, String contentType, int size) {
        this(partName, null, content, contentType, size);
    }

    public HttpBodyPart(String partName, String fileName, byte[] content, String contentType, int size) {
        this.partName = partName;
        this.fileName = fileName;
        this.content = Arrays.copyOf(content, content.length);
        this.contentType = contentType;
        this.size = size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return Arrays.copyOf(this.content, this.content.length);
    }

    public String getPartName() {
        return this.partName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSize() {
        return this.size;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }
}

