/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.websocket.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.websocket.ServerHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketConnection;
import org.wso2.transport.http.netty.contract.websocket.WebSocketHandshaker;
import org.wso2.transport.http.netty.contractimpl.listener.MaxEntityBodyValidator;
import org.wso2.transport.http.netty.contractimpl.listener.MessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.listener.UriAndHeaderLengthValidator;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultServerHandshakeFuture;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketInboundFrameHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.WebSocketUtil;
import org.wso2.transport.http.netty.message.HttpCarbonRequest;

public class DefaultWebSocketHandshaker
implements WebSocketHandshaker {
    private final ChannelHandlerContext ctx;
    private final FullHttpRequest httpRequest;
    private final ServerConnectorFuture connectorFuture;
    private final String target;
    private final boolean secureConnection;
    private boolean cancelled = false;
    private boolean handshakeStarted = false;
    private HttpCarbonRequest request;
    private boolean allowExtensions;

    public DefaultWebSocketHandshaker(ChannelHandlerContext ctx, ServerConnectorFuture connectorFuture, FullHttpRequest httpRequest, String target, boolean allowExtensions) {
        this.ctx = ctx;
        this.connectorFuture = connectorFuture;
        this.secureConnection = ctx.channel().pipeline().get("ssl") != null;
        this.httpRequest = httpRequest;
        this.target = target;
        this.allowExtensions = allowExtensions;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public ServerHandshakeFuture handshake() {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), null, this.allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, 0, null);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), this.allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, 0, null);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), this.allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, null);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout, HttpHeaders responseHeaders) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), this.allowExtensions);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, responseHeaders);
    }

    @Override
    public ServerHandshakeFuture handshake(String[] subProtocols, int idleTimeout, HttpHeaders responseHeaders, int maxFramePayloadLength) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketURL(this.httpRequest), this.getSubProtocolsCSV(subProtocols), this.allowExtensions, maxFramePayloadLength);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(this.httpRequest);
        return this.handleHandshake(handshaker, idleTimeout, responseHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture cancelHandshake(int statusCode, String closeReason) {
        if (this.cancelled) {
            throw new IllegalStateException("Cannot cancel the handshake: handshake already cancelled");
        }
        if (this.handshakeStarted) {
            throw new IllegalStateException("Cannot cancel the handshake: handshake already started");
        }
        try {
            ChannelFuture responseFuture;
            int responseStatusCode;
            int n = responseStatusCode = statusCode >= 400 && statusCode < 600 ? statusCode : 400;
            if (closeReason != null) {
                ByteBuf content = Unpooled.wrappedBuffer(closeReason.getBytes(StandardCharsets.UTF_8));
                responseFuture = this.ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(responseStatusCode), content));
            } else {
                responseFuture = this.ctx.writeAndFlush(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(responseStatusCode)));
            }
            responseFuture.addListener(future -> this.ctx.close());
            ChannelFuture channelFuture = responseFuture;
            return channelFuture;
        }
        finally {
            this.cancelled = true;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isHandshakeStarted() {
        return this.handshakeStarted;
    }

    @Override
    public boolean isSecure() {
        return this.secureConnection;
    }

    @Override
    public boolean isServerMessage() {
        return true;
    }

    @Override
    public WebSocketConnection getWebSocketConnection() {
        throw new IllegalStateException("Cannot get WebSocket connection without handshake completion");
    }

    @Override
    public String getChannelId() {
        return WebSocketUtil.getChannelId(this.ctx);
    }

    private ServerHandshakeFuture handleHandshake(WebSocketServerHandshaker handshaker, int idleTimeout, HttpHeaders headers) {
        DefaultServerHandshakeFuture handshakeFuture = new DefaultServerHandshakeFuture();
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(this.ctx.channel());
            handshakeFuture.notifyError(new UnsupportedOperationException("Unsupported WebSocket version"));
            return handshakeFuture;
        }
        if (this.cancelled) {
            IllegalAccessException e = new IllegalAccessException("Handshake is already cancelled.");
            handshakeFuture.notifyError(e);
            return handshakeFuture;
        }
        ChannelFuture channelFuture = handshaker.handshake(this.ctx.channel(), this.httpRequest, headers, this.ctx.channel().newPromise());
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess() && future.cause() == null) {
                WebSocketInboundFrameHandler frameHandler = new WebSocketInboundFrameHandler(true, this.secureConnection, this.target, handshaker.selectedSubprotocol(), this.connectorFuture, new MessageQueueHandler());
                this.configureFrameHandlingPipeline(idleTimeout, frameHandler);
                handshakeFuture.notifySuccess(frameHandler.getWebSocketConnection());
            } else {
                handshakeFuture.notifyError(future.cause());
            }
        }));
        this.handshakeStarted = true;
        return handshakeFuture;
    }

    private void configureFrameHandlingPipeline(int idleTimeout, WebSocketInboundFrameHandler frameHandler) {
        ChannelPipeline pipeline = this.ctx.pipeline();
        pipeline.remove("websocket-server-handshake-handler");
        pipeline.remove("chunkWriter");
        if (pipeline.get(UriAndHeaderLengthValidator.class) == null) {
            pipeline.remove(UriAndHeaderLengthValidator.class);
        }
        if (pipeline.get(MaxEntityBodyValidator.class) != null) {
            pipeline.remove(MaxEntityBodyValidator.class);
        }
        if (idleTimeout > 0) {
            pipeline.replace("idleStateHandler", "idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, idleTimeout, TimeUnit.MILLISECONDS));
        } else {
            pipeline.remove("idleStateHandler");
        }
        pipeline.addLast("WEBSOCKET_FRAME_HANDLER", (ChannelHandler)frameHandler);
        frameHandler.getWebSocketConnection().stopReadingFrames();
        pipeline.fireChannelActive();
    }

    private String getWebSocketURL(HttpRequest req) {
        String protocol = "ws";
        if (this.secureConnection) {
            protocol = "wss";
        }
        return protocol + "://" + req.headers().get("Host") + req.uri();
    }

    private String getSubProtocolsCSV(String[] subProtocols) {
        if (subProtocols == null || subProtocols.length == 0) {
            return null;
        }
        String subProtocolsStr = "";
        for (String subProtocol : subProtocols) {
            subProtocolsStr = subProtocolsStr.concat(subProtocol + ",");
        }
        subProtocolsStr = subProtocolsStr.substring(0, subProtocolsStr.length() - 1);
        return subProtocolsStr;
    }

    @Override
    public HttpCarbonRequest getHttpCarbonRequest() {
        return this.request;
    }

    public void setHttpCarbonRequest(HttpCarbonRequest request) {
        this.request = request;
    }
}

