/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.listener;

import io.netty.handler.codec.http.HttpHeaderNames;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class RequestDataHolder {
    private String acceptEncodingHeaderValue;
    private String connectionHeaderValue;
    private String contentTypeHeaderValue;
    private String transferEncodingHeaderValue;
    private String contentLengthHeaderValue;
    private String httpMethod;
    private String httpVersion;

    public RequestDataHolder(HttpCarbonMessage requestMessage) {
        this.acceptEncodingHeaderValue = requestMessage.getHeader(HttpHeaderNames.ACCEPT_ENCODING.toString());
        this.connectionHeaderValue = requestMessage.getHeader(HttpHeaderNames.CONNECTION.toString());
        this.contentTypeHeaderValue = requestMessage.getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
        this.transferEncodingHeaderValue = requestMessage.getHeader(HttpHeaderNames.TRANSFER_ENCODING.toString());
        this.contentLengthHeaderValue = requestMessage.getHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        this.httpMethod = (String)requestMessage.getProperty("HTTP_METHOD");
        this.httpVersion = (String)requestMessage.getProperty("HTTP_VERSION");
    }

    public String getAcceptEncodingHeaderValue() {
        return this.acceptEncodingHeaderValue;
    }

    public String getConnectionHeaderValue() {
        return this.connectionHeaderValue;
    }

    public String getContentTypeHeaderValue() {
        return this.contentTypeHeaderValue;
    }

    public String getTransferEncodingHeaderValue() {
        return this.transferEncodingHeaderValue;
    }

    public String getContentLengthHeaderValue() {
        return this.contentLengthHeaderValue;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }
}

