/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.startupresolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupServiceCache {
    private static final Logger logger = LoggerFactory.getLogger(StartupServiceCache.class);
    private static StartupServiceCache serviceCacheInstance = new StartupServiceCache();
    private Map<String, Map<String, Long>> componentMap = new HashMap<String, Map<String, Long>>();

    public static StartupServiceCache getInstance() {
        return serviceCacheInstance;
    }

    private StartupServiceCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String componentName, Class interfaceName) {
        logger.debug("Updating StartupServiceCache, componentName={}, interfaceName={}.", (Object)componentName, (Object)interfaceName.getName());
        Map<String, Map<String, Long>> map = this.componentMap;
        synchronized (map) {
            Long serviceCount;
            Map<String, Long> componentServicesMap = this.componentMap.get(componentName);
            if (componentServicesMap == null) {
                logger.debug("Creating a Component Services Map for component {}", (Object)componentName);
                componentServicesMap = new HashMap<String, Long>();
                this.componentMap.put(componentName, componentServicesMap);
            }
            if ((serviceCount = componentServicesMap.get(interfaceName.getName())) == null) {
                logger.debug("Creating a Service Instance List for interface {} in component {}", (Object)interfaceName, (Object)componentName);
                serviceCount = 1L;
            } else {
                Long l = serviceCount;
                Long l2 = serviceCount = Long.valueOf(serviceCount + 1L);
            }
            componentServicesMap.put(interfaceName.getName(), serviceCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getAvailableService(String componentName) {
        Map<String, Map<String, Long>> map = this.componentMap;
        synchronized (map) {
            Map<String, Long> availableServices = this.componentMap.get(componentName);
            if (availableServices == null) {
                return Collections.emptyMap();
            }
            return availableServices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, stringLongEntry -> (long)((Long)stringLongEntry.getValue())));
        }
    }
}

