/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.guava;

import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

public class GuavaCache
implements Cache {
    private static final Object NULL_HOLDER = new NullHolder();
    private final String name;
    private final com.google.common.cache.Cache<Object, Object> cache;
    private final boolean allowNullValues;

    public GuavaCache(String name, com.google.common.cache.Cache<Object, Object> cache) {
        this(name, cache, true);
    }

    public GuavaCache(String name, com.google.common.cache.Cache<Object, Object> cache, boolean allowNullValues) {
        Assert.notNull(name, "Name must not be null");
        Assert.notNull(cache, "Cache must not be null");
        this.name = name;
        this.cache = cache;
        this.allowNullValues = allowNullValues;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final com.google.common.cache.Cache<Object, Object> getNativeCache() {
        return this.cache;
    }

    public final boolean isAllowNullValues() {
        return this.allowNullValues;
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        if (this.cache instanceof LoadingCache) {
            try {
                Object value = ((LoadingCache)this.cache).get(key);
                return this.toWrapper(value);
            }
            catch (ExecutionException ex) {
                throw new UncheckedExecutionException(ex.getMessage(), ex);
            }
        }
        return this.toWrapper(this.cache.getIfPresent(key));
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.cache.getIfPresent(key));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    @Override
    public void put(Object key, Object value) {
        this.cache.put(key, this.toStoreValue(value));
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        try {
            PutIfAbsentCallable callable = new PutIfAbsentCallable(value);
            Object result = this.cache.get(key, callable);
            return callable.called ? null : this.toWrapper(result);
        }
        catch (ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void evict(Object key) {
        this.cache.invalidate(key);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    protected Object fromStoreValue(Object storeValue) {
        if (this.allowNullValues && storeValue == NULL_HOLDER) {
            return null;
        }
        return storeValue;
    }

    protected Object toStoreValue(Object userValue) {
        if (this.allowNullValues && userValue == null) {
            return NULL_HOLDER;
        }
        return userValue;
    }

    private Cache.ValueWrapper toWrapper(Object value) {
        return value != null ? new SimpleValueWrapper(this.fromStoreValue(value)) : null;
    }

    private class PutIfAbsentCallable
    implements Callable<Object> {
        private final Object value;
        private boolean called;

        public PutIfAbsentCallable(Object value) {
            this.value = value;
        }

        @Override
        public Object call() throws Exception {
            this.called = true;
            return GuavaCache.this.toStoreValue(this.value);
        }
    }

    private static class NullHolder
    implements Serializable {
        private NullHolder() {
        }
    }
}

