/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AbstractAliasAwareAnnotationAttributeExtractor;
import org.springframework.util.ReflectionUtils;

class DefaultAnnotationAttributeExtractor
extends AbstractAliasAwareAnnotationAttributeExtractor {
    DefaultAnnotationAttributeExtractor(Annotation annotation, AnnotatedElement annotatedElement) {
        super(annotation.annotationType(), annotatedElement, annotation);
    }

    @Override
    public Annotation getSource() {
        return (Annotation)super.getSource();
    }

    @Override
    protected Object getRawAttributeValue(Method attributeMethod) {
        ReflectionUtils.makeAccessible(attributeMethod);
        return ReflectionUtils.invokeMethod(attributeMethod, this.getSource());
    }

    @Override
    protected Object getRawAttributeValue(String attributeName) {
        Method attributeMethod = ReflectionUtils.findMethod(this.getSource().annotationType(), attributeName);
        return this.getRawAttributeValue(attributeMethod);
    }
}

