/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsAsyncClientHttpRequest;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;

public class HttpComponentsAsyncClientHttpRequestFactory
extends HttpComponentsClientHttpRequestFactory
implements AsyncClientHttpRequestFactory,
InitializingBean {
    private CloseableHttpAsyncClient httpAsyncClient;

    public HttpComponentsAsyncClientHttpRequestFactory() {
        this(HttpAsyncClients.createSystem());
    }

    public HttpComponentsAsyncClientHttpRequestFactory(CloseableHttpAsyncClient httpAsyncClient) {
        Assert.notNull(httpAsyncClient, "HttpAsyncClient must not be null");
        this.httpAsyncClient = httpAsyncClient;
    }

    public HttpComponentsAsyncClientHttpRequestFactory(CloseableHttpClient httpClient, CloseableHttpAsyncClient httpAsyncClient) {
        super((HttpClient)httpClient);
        Assert.notNull(httpAsyncClient, "HttpAsyncClient must not be null");
        this.httpAsyncClient = httpAsyncClient;
    }

    public void setHttpAsyncClient(CloseableHttpAsyncClient httpAsyncClient) {
        this.httpAsyncClient = httpAsyncClient;
    }

    public CloseableHttpAsyncClient getHttpAsyncClient() {
        return this.httpAsyncClient;
    }

    @Override
    public void afterPropertiesSet() {
        this.startAsyncClient();
    }

    private void startAsyncClient() {
        CloseableHttpAsyncClient asyncClient = this.getHttpAsyncClient();
        if (!asyncClient.isRunning()) {
            asyncClient.start();
        }
    }

    @Override
    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) throws IOException {
        CloseableHttpAsyncClient asyncClient = this.getHttpAsyncClient();
        this.startAsyncClient();
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        if (context.getAttribute("http.request-config") == null) {
            RequestConfig config = null;
            if (httpRequest instanceof Configurable) {
                config = ((Configurable)httpRequest).getConfig();
            }
            if (config == null) {
                config = this.createRequestConfig(asyncClient);
            }
            if (config != null) {
                context.setAttribute("http.request-config", (Object)config);
            }
        }
        return new HttpComponentsAsyncClientHttpRequest((HttpAsyncClient)asyncClient, httpRequest, context);
    }

    @Override
    public void destroy() throws Exception {
        try {
            super.destroy();
        }
        finally {
            this.getHttpAsyncClient().close();
        }
    }
}

