/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.StreamingHttpOutputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BufferedImageHttpMessageConverter
implements HttpMessageConverter<BufferedImage> {
    private final List<MediaType> readableMediaTypes = new ArrayList<MediaType>();
    private MediaType defaultContentType;
    private File cacheDir;

    public BufferedImageHttpMessageConverter() {
        String[] writerMediaTypes;
        String[] readerMediaTypes;
        for (String mediaType : readerMediaTypes = ImageIO.getReaderMIMETypes()) {
            if (!StringUtils.hasText(mediaType)) continue;
            this.readableMediaTypes.add(MediaType.parseMediaType(mediaType));
        }
        for (String mediaType : writerMediaTypes = ImageIO.getWriterMIMETypes()) {
            if (!StringUtils.hasText(mediaType)) continue;
            this.defaultContentType = MediaType.parseMediaType(mediaType);
            break;
        }
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        Assert.notNull(defaultContentType, "'contentType' must not be null");
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(defaultContentType.toString());
        if (!imageWriters.hasNext()) {
            throw new IllegalArgumentException("Content-Type [" + defaultContentType + "] is not supported by the Java Image I/O API");
        }
        this.defaultContentType = defaultContentType;
    }

    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setCacheDir(File cacheDir) {
        Assert.notNull(cacheDir, "'cacheDir' must not be null");
        Assert.isTrue(cacheDir.isDirectory(), "'cacheDir' is not a directory");
        this.cacheDir = cacheDir;
    }

    @Override
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return BufferedImage.class == clazz && this.isReadable(mediaType);
    }

    private boolean isReadable(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(mediaType.toString());
        return imageReaders.hasNext();
    }

    @Override
    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return BufferedImage.class == clazz && this.isWritable(mediaType);
    }

    private boolean isWritable(MediaType mediaType) {
        if (mediaType == null || MediaType.ALL.equals(mediaType)) {
            return true;
        }
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(mediaType.toString());
        return imageWriters.hasNext();
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.unmodifiableList(this.readableMediaTypes);
    }

    @Override
    public BufferedImage read(Class<? extends BufferedImage> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = null;
        try {
            imageInputStream = this.createImageInputStream(inputMessage.getBody());
            MediaType contentType = inputMessage.getHeaders().getContentType();
            Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(contentType.toString());
            if (imageReaders.hasNext()) {
                imageReader = imageReaders.next();
                ImageReadParam irp = imageReader.getDefaultReadParam();
                this.process(irp);
                imageReader.setInput(imageInputStream, true);
                BufferedImage bufferedImage = imageReader.read(0, irp);
                return bufferedImage;
            }
            throw new HttpMessageNotReadableException("Could not find javax.imageio.ImageReader for Content-Type [" + contentType + "]");
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            if (imageInputStream != null) {
                try {
                    imageInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ImageInputStream createImageInputStream(InputStream is) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageInputStream(is, this.cacheDir);
        }
        return new MemoryCacheImageInputStream(is);
    }

    @Override
    public void write(final BufferedImage image, final MediaType contentType, final HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){

                @Override
                public void writeTo(OutputStream outputStream) throws IOException {
                    BufferedImageHttpMessageConverter.this.writeInternal(image, contentType, outputMessage.getHeaders(), outputStream);
                }
            });
        } else {
            this.writeInternal(image, contentType, outputMessage.getHeaders(), outputMessage.getBody());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInternal(BufferedImage image, MediaType contentType, HttpHeaders headers, OutputStream body) throws IOException, HttpMessageNotWritableException {
        block11: {
            if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
                contentType = this.getDefaultContentType();
            }
            Assert.notNull(contentType, "Count not determine Content-Type, set one using the 'defaultContentType' property");
            headers.setContentType(contentType);
            ImageInputStream imageOutputStream = null;
            ImageWriter imageWriter = null;
            try {
                Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByMIMEType(contentType.toString());
                if (imageWriters.hasNext()) {
                    imageWriter = imageWriters.next();
                    ImageWriteParam iwp = imageWriter.getDefaultWriteParam();
                    this.process(iwp);
                    imageOutputStream = this.createImageOutputStream(body);
                    imageWriter.setOutput(imageOutputStream);
                    imageWriter.write(null, new IIOImage(image, null, null), iwp);
                    break block11;
                }
                throw new HttpMessageNotWritableException("Could not find javax.imageio.ImageWriter for Content-Type [" + contentType + "]");
            }
            finally {
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
                if (imageOutputStream != null) {
                    try {
                        imageOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private ImageOutputStream createImageOutputStream(OutputStream os) throws IOException {
        if (this.cacheDir != null) {
            return new FileCacheImageOutputStream(os, this.cacheDir);
        }
        return new MemoryCacheImageOutputStream(os);
    }

    protected void process(ImageReadParam irp) {
    }

    protected void process(ImageWriteParam iwp) {
    }
}

