/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.annotation.AnnotationBeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedNotification;
import org.springframework.jmx.export.annotation.ManagedNotifications;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.util.StringValueResolver;

public class AnnotationJmxAttributeSource
implements JmxAttributeSource,
BeanFactoryAware {
    private StringValueResolver embeddedValueResolver;

    @Override
    public void setBeanFactory(final BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new StringValueResolver(){

                @Override
                public String resolveStringValue(String strVal) {
                    return ((ConfigurableBeanFactory)beanFactory).resolveEmbeddedValue(strVal);
                }
            };
        }
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedResource getManagedResource(Class<?> beanClass) throws InvalidMetadataException {
        ManagedResource ann = AnnotationUtils.getAnnotation(beanClass, ManagedResource.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedResource managedResource = new org.springframework.jmx.export.metadata.ManagedResource();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedResource, this.embeddedValueResolver, new String[0]);
        return managedResource;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedAttribute getManagedAttribute(Method method) throws InvalidMetadataException {
        ManagedAttribute ann = AnnotationUtils.findAnnotation(method, ManagedAttribute.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedAttribute managedAttribute = new org.springframework.jmx.export.metadata.ManagedAttribute();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedAttribute, "defaultValue");
        if (ann.defaultValue().length() > 0) {
            managedAttribute.setDefaultValue(ann.defaultValue());
        }
        return managedAttribute;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedMetric getManagedMetric(Method method) throws InvalidMetadataException {
        ManagedMetric ann = AnnotationUtils.findAnnotation(method, ManagedMetric.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedMetric managedMetric = new org.springframework.jmx.export.metadata.ManagedMetric();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)managedMetric, new String[0]);
        return managedMetric;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedOperation getManagedOperation(Method method) throws InvalidMetadataException {
        ManagedOperation ann = AnnotationUtils.findAnnotation(method, ManagedOperation.class);
        if (ann == null) {
            return null;
        }
        org.springframework.jmx.export.metadata.ManagedOperation op = new org.springframework.jmx.export.metadata.ManagedOperation();
        AnnotationBeanUtils.copyPropertiesToBean((Annotation)ann, (Object)op, new String[0]);
        return op;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedOperationParameter[] getManagedOperationParameters(Method method) throws InvalidMetadataException {
        ManagedOperationParameters params = AnnotationUtils.findAnnotation(method, ManagedOperationParameters.class);
        org.springframework.jmx.export.metadata.ManagedOperationParameter[] result = null;
        if (params == null) {
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[]{};
        } else {
            ManagedOperationParameter[] paramData = params.value();
            result = new org.springframework.jmx.export.metadata.ManagedOperationParameter[paramData.length];
            for (int i = 0; i < paramData.length; ++i) {
                ManagedOperationParameter annotation = paramData[i];
                org.springframework.jmx.export.metadata.ManagedOperationParameter managedOperationParameter = new org.springframework.jmx.export.metadata.ManagedOperationParameter();
                AnnotationBeanUtils.copyPropertiesToBean((Annotation)annotation, (Object)managedOperationParameter, new String[0]);
                result[i] = managedOperationParameter;
            }
        }
        return result;
    }

    @Override
    public org.springframework.jmx.export.metadata.ManagedNotification[] getManagedNotifications(Class<?> clazz) throws InvalidMetadataException {
        ManagedNotifications notificationsAnn = AnnotationUtils.getAnnotation(clazz, ManagedNotifications.class);
        if (notificationsAnn == null) {
            return new org.springframework.jmx.export.metadata.ManagedNotification[0];
        }
        ManagedNotification[] notifications = notificationsAnn.value();
        org.springframework.jmx.export.metadata.ManagedNotification[] result = new org.springframework.jmx.export.metadata.ManagedNotification[notifications.length];
        for (int i = 0; i < notifications.length; ++i) {
            ManagedNotification notification = notifications[i];
            org.springframework.jmx.export.metadata.ManagedNotification managedNotification = new org.springframework.jmx.export.metadata.ManagedNotification();
            AnnotationBeanUtils.copyPropertiesToBean((Annotation)notification, (Object)managedNotification, new String[0]);
            result[i] = managedNotification;
        }
        return result;
    }
}

