/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.msf4j.internal.mime.MimeMapper;
import org.wso2.msf4j.internal.mime.MimeMappingException;

public class FileEntityWriter
implements EntityWriter<File> {
    public static final int DEFAULT_CHUNK_SIZE = 1024;

    @Override
    public Class<File> getType() {
        return File.class;
    }

    @Override
    public void writeData(CarbonMessage carbonMessage, File file, String mediaType, int chunkSize, CarbonCallback cb) {
        if (mediaType == null || mediaType.equals("*/*")) {
            try {
                mediaType = MimeMapper.getMimeType(Files.getFileExtension(file.getName()));
            }
            catch (MimeMappingException e) {
                mediaType = "*/*";
            }
        }
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            if (chunkSize == 0 || chunkSize == -1) {
                chunkSize = 1024;
            }
            carbonMessage.setHeader("Transfer-Encoding", "chunked");
            carbonMessage.setHeader("Content-Type", mediaType);
            carbonMessage.setBufferContent(false);
            cb.done(carbonMessage);
            ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
            while (fileChannel.read(buffer) != -1) {
                buffer.flip();
                carbonMessage.addMessageBody(buffer);
            }
            fileChannel.close();
            carbonMessage.setEndOfMsgAdded(true);
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while reading from file", e);
        }
    }
}

