/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouter;

public final class MicroserviceMetadata {
    private static final Logger log = LoggerFactory.getLogger(MicroserviceMetadata.class);
    private final PatternPathRouter<HttpResourceModel> patternRouter = PatternPathRouter.create();

    public MicroserviceMetadata(Iterable<? extends Object> services) {
        for (Object object : services) {
            String basePath = "";
            if (object.getClass().isAnnotationPresent(Path.class)) {
                basePath = object.getClass().getAnnotation(Path.class).value();
            }
            for (Method method : object.getClass().getMethods()) {
                if (method.isAnnotationPresent(PostConstruct.class) || method.isAnnotationPresent(PreDestroy.class)) continue;
                if (Modifier.isPublic(method.getModifiers()) && this.isHttpMethodAvailable(method)) {
                    String relativePath = "";
                    if (method.getAnnotation(Path.class) != null) {
                        relativePath = method.getAnnotation(Path.class).value();
                    }
                    String absolutePath = String.format("%s/%s", basePath, relativePath);
                    this.patternRouter.add(absolutePath, new HttpResourceModel(absolutePath, method, object));
                    continue;
                }
                log.trace("Not adding method {}({}) to path routing like. HTTP calls will not be routed to this method", (Object)method.getName(), (Object)method.getParameterTypes());
            }
        }
    }

    private boolean isHttpMethodAvailable(Method method) {
        return method.isAnnotationPresent(GET.class) || method.isAnnotationPresent(PUT.class) || method.isAnnotationPresent(POST.class) || method.isAnnotationPresent(DELETE.class);
    }

    public PatternPathRouter.RoutableDestination<HttpResourceModel> getDestinationMethod(String uri, String httpMethod, String contentTypeHeader, List<String> acceptHeader) throws HandlerException {
        try {
            String path = URI.create(uri).normalize().getPath();
            List<PatternPathRouter.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
            List<PatternPathRouter.RoutableDestination<HttpResourceModel>> matchedDestinations = this.getMatchedDestination(routableDestinations, httpMethod, path);
            if (!matchedDestinations.isEmpty()) {
                return matchedDestinations.stream().filter(matchedDestination1 -> ((HttpResourceModel)matchedDestination1.getDestination()).matchConsumeMediaType(contentTypeHeader) && ((HttpResourceModel)matchedDestination1.getDestination()).matchProduceMediaType(acceptHeader)).findFirst().get();
            }
            if (!routableDestinations.isEmpty()) {
                throw new HandlerException(Response.Status.METHOD_NOT_ALLOWED, uri);
            }
            throw new HandlerException(Response.Status.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", uri));
        }
        catch (NoSuchElementException ex) {
            throw new HandlerException(Response.Status.UNSUPPORTED_MEDIA_TYPE, String.format("Problem accessing: %s. Reason: Unsupported Media Type", uri), ex);
        }
    }

    private List<PatternPathRouter.RoutableDestination<HttpResourceModel>> getMatchedDestination(List<PatternPathRouter.RoutableDestination<HttpResourceModel>> routableDestinations, String targetHttpMethod, String requestUri) {
        Iterable<String> requestUriParts = Splitter.on('/').omitEmptyStrings().split(requestUri);
        ArrayList<PatternPathRouter.RoutableDestination<HttpResourceModel>> matchedDestinations = Lists.newArrayListWithExpectedSize(routableDestinations.size());
        int maxExactMatch = 0;
        int maxGroupMatch = 0;
        int maxPatternLength = 0;
        for (PatternPathRouter.RoutableDestination<HttpResourceModel> destination : routableDestinations) {
            HttpResourceModel resourceModel = destination.getDestination();
            int groupMatch = destination.getGroupNameValues().size();
            for (String httpMethod : resourceModel.getHttpMethod()) {
                if (!targetHttpMethod.equals(httpMethod)) continue;
                int exactMatch = this.getExactPrefixMatchCount(requestUriParts, Splitter.on('/').omitEmptyStrings().split(resourceModel.getPath()));
                if (exactMatch > maxExactMatch) {
                    maxExactMatch = exactMatch;
                    maxGroupMatch = groupMatch;
                    maxPatternLength = resourceModel.getPath().length();
                    matchedDestinations.clear();
                    matchedDestinations.add(destination);
                    continue;
                }
                if (exactMatch != maxExactMatch || groupMatch < maxGroupMatch) continue;
                if (groupMatch > maxGroupMatch || resourceModel.getPath().length() > maxPatternLength) {
                    maxGroupMatch = groupMatch;
                    maxPatternLength = resourceModel.getPath().length();
                    matchedDestinations.clear();
                }
                matchedDestinations.add(destination);
            }
        }
        return matchedDestinations;
    }

    private int getExactPrefixMatchCount(Iterable<String> first, Iterable<String> second) {
        int count = 0;
        Iterator<String> fit = first.iterator();
        Iterator<String> sit = second.iterator();
        while (fit.hasNext() && sit.hasNext() && fit.next().equals(sit.next())) {
            ++count;
        }
        return count;
    }
}

