/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.swagger;

import io.swagger.util.Json;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.wso2.msf4j.internal.MicroservicesRegistry;
import org.wso2.msf4j.internal.swagger.MSF4JBeanConfig;

@Path(value="/swagger")
public class SwaggerDefinitionService {
    private static final String GLOBAL = "global";
    private Map<String, MSF4JBeanConfig> swaggerBeans = new HashMap<String, MSF4JBeanConfig>();
    private MicroservicesRegistry serviceRegistry;

    public SwaggerDefinitionService(MicroservicesRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSwaggerDefinition(@QueryParam(value="path") String path) throws Exception {
        MSF4JBeanConfig msf4JBeanConfig;
        if (path == null) {
            msf4JBeanConfig = this.swaggerBeans.get(GLOBAL);
            if (msf4JBeanConfig == null) {
                MSF4JBeanConfig beanConfig = new MSF4JBeanConfig();
                this.serviceRegistry.getHttpServices().stream().forEach(service -> beanConfig.addServiceClass(service.getClass()));
                beanConfig.setScan(true);
                msf4JBeanConfig = beanConfig;
                this.swaggerBeans.put(GLOBAL, msf4JBeanConfig);
            }
        } else {
            Optional<Object> service2;
            msf4JBeanConfig = this.swaggerBeans.get(path);
            if (msf4JBeanConfig == null && (service2 = this.serviceRegistry.getServiceWithBasePath(path)).isPresent()) {
                MSF4JBeanConfig beanConfig = new MSF4JBeanConfig();
                beanConfig.addServiceClass(service2.get().getClass());
                beanConfig.setScan(true);
                msf4JBeanConfig = beanConfig;
                this.swaggerBeans.put(path, msf4JBeanConfig);
            }
        }
        return msf4JBeanConfig == null ? Response.status(Response.Status.NOT_FOUND).entity("{\"error\": \"Swagger definition not found for path " + path + "\"}").build() : Response.status(Response.Status.OK).entity(Json.mapper().writerWithDefaultPrettyPrinter().writeValueAsString(msf4JBeanConfig.getSwagger())).build();
    }
}

