/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.SessionAttributesHandler;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;

public final class ModelFactory {
    private static final Log logger = LogFactory.getLog(ModelFactory.class);
    private final List<ModelMethod> modelMethods = new ArrayList<ModelMethod>();
    private final WebDataBinderFactory dataBinderFactory;
    private final SessionAttributesHandler sessionAttributesHandler;

    public ModelFactory(List<InvocableHandlerMethod> invocableMethods, WebDataBinderFactory dataBinderFactory, SessionAttributesHandler sessionAttributesHandler) {
        if (invocableMethods != null) {
            for (InvocableHandlerMethod method : invocableMethods) {
                this.modelMethods.add(new ModelMethod(method));
            }
        }
        this.dataBinderFactory = dataBinderFactory;
        this.sessionAttributesHandler = sessionAttributesHandler;
    }

    public void initModel(NativeWebRequest request, ModelAndViewContainer mavContainer, HandlerMethod handlerMethod) throws Exception {
        Map<String, Object> sessionAttributes = this.sessionAttributesHandler.retrieveAttributes(request);
        mavContainer.mergeAttributes(sessionAttributes);
        this.invokeModelAttributeMethods(request, mavContainer);
        for (String name : this.findSessionAttributeArguments(handlerMethod)) {
            if (mavContainer.containsAttribute(name)) continue;
            Object value = this.sessionAttributesHandler.retrieveAttribute(request, name);
            if (value == null) {
                throw new HttpSessionRequiredException("Expected session attribute '" + name + "'");
            }
            mavContainer.addAttribute(name, value);
        }
    }

    private void invokeModelAttributeMethods(NativeWebRequest request, ModelAndViewContainer mavContainer) throws Exception {
        while (!this.modelMethods.isEmpty()) {
            String returnValueName;
            InvocableHandlerMethod attrMethod = this.getNextModelMethod(mavContainer).getHandlerMethod();
            String modelName = attrMethod.getMethodAnnotation(ModelAttribute.class).value();
            if (mavContainer.containsAttribute(modelName)) continue;
            Object returnValue = attrMethod.invokeForRequest(request, mavContainer, new Object[0]);
            if (attrMethod.isVoid() || mavContainer.containsAttribute(returnValueName = ModelFactory.getNameForReturnValue(returnValue, attrMethod.getReturnType()))) continue;
            mavContainer.addAttribute(returnValueName, returnValue);
        }
    }

    private ModelMethod getNextModelMethod(ModelAndViewContainer mavContainer) {
        for (ModelMethod modelMethod : this.modelMethods) {
            if (!modelMethod.checkDependencies(mavContainer)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Selected @ModelAttribute method " + modelMethod);
            }
            this.modelMethods.remove(modelMethod);
            return modelMethod;
        }
        ModelMethod modelMethod = this.modelMethods.get(0);
        if (logger.isTraceEnabled()) {
            logger.trace("Selected @ModelAttribute method (not present: " + modelMethod.getUnresolvedDependencies(mavContainer) + ") " + modelMethod);
        }
        this.modelMethods.remove(modelMethod);
        return modelMethod;
    }

    private List<String> findSessionAttributeArguments(HandlerMethod handlerMethod) {
        ArrayList<String> result = new ArrayList<String>();
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            String name;
            if (!parameter.hasParameterAnnotation(ModelAttribute.class) || !this.sessionAttributesHandler.isHandlerSessionAttribute(name = ModelFactory.getNameForParameter(parameter), parameter.getParameterType())) continue;
            result.add(name);
        }
        return result;
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute annot = parameter.getParameterAnnotation(ModelAttribute.class);
        String attrName = annot != null ? annot.value() : null;
        return StringUtils.hasText(attrName) ? attrName : Conventions.getVariableNameForParameter(parameter);
    }

    public static String getNameForReturnValue(Object returnValue, MethodParameter returnType) {
        ModelAttribute annotation = returnType.getMethodAnnotation(ModelAttribute.class);
        if (annotation != null && StringUtils.hasText(annotation.value())) {
            return annotation.value();
        }
        Method method = returnType.getMethod();
        Class<?> resolvedType = GenericTypeResolver.resolveReturnType(method, returnType.getContainingClass());
        return Conventions.getVariableNameForReturnType(method, resolvedType, returnValue);
    }

    public void updateModel(NativeWebRequest request, ModelAndViewContainer mavContainer) throws Exception {
        ModelMap defaultModel = mavContainer.getDefaultModel();
        if (mavContainer.getSessionStatus().isComplete()) {
            this.sessionAttributesHandler.cleanupAttributes(request);
        } else {
            this.sessionAttributesHandler.storeAttributes(request, defaultModel);
        }
        if (!mavContainer.isRequestHandled() && mavContainer.getModel() == defaultModel) {
            this.updateBindingResult(request, defaultModel);
        }
    }

    private void updateBindingResult(NativeWebRequest request, ModelMap model) throws Exception {
        ArrayList keyNames = new ArrayList(model.keySet());
        for (String name : keyNames) {
            String bindingResultKey;
            Object value;
            if (!this.isBindingCandidate(name, value = model.get(name)) || model.containsAttribute(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + name)) continue;
            WebDataBinder dataBinder = this.dataBinderFactory.createBinder(request, value, name);
            model.put(bindingResultKey, dataBinder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String attributeName, Object value) {
        Class<?> attrType;
        if (attributeName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        Class<?> clazz = attrType = value != null ? value.getClass() : null;
        if (this.sessionAttributesHandler.isHandlerSessionAttribute(attributeName, attrType)) {
            return true;
        }
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }

    private static class ModelMethod {
        private final InvocableHandlerMethod handlerMethod;
        private final Set<String> dependencies = new HashSet<String>();

        private ModelMethod(InvocableHandlerMethod handlerMethod) {
            this.handlerMethod = handlerMethod;
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!parameter.hasParameterAnnotation(ModelAttribute.class)) continue;
                this.dependencies.add(ModelFactory.getNameForParameter(parameter));
            }
        }

        public InvocableHandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public boolean checkDependencies(ModelAndViewContainer mavContainer) {
            for (String name : this.dependencies) {
                if (mavContainer.containsAttribute(name)) continue;
                return false;
            }
            return true;
        }

        public List<String> getUnresolvedDependencies(ModelAndViewContainer mavContainer) {
            ArrayList<String> result = new ArrayList<String>(this.dependencies.size());
            for (String name : this.dependencies) {
                if (mavContainer.containsAttribute(name)) continue;
                result.add(name);
            }
            return result;
        }

        public String toString() {
            return this.handlerMethod.getMethod().toGenericString();
        }
    }
}

