/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.support;

import java.util.Map;
import org.springframework.ui.ModelMap;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;

public class ModelAndViewContainer {
    private boolean ignoreDefaultModelOnRedirect = false;
    private Object view;
    private final ModelMap defaultModel = new BindingAwareModelMap();
    private ModelMap redirectModel;
    private boolean redirectModelScenario = false;
    private final SessionStatus sessionStatus = new SimpleSessionStatus();
    private boolean requestHandled = false;

    public void setIgnoreDefaultModelOnRedirect(boolean ignoreDefaultModelOnRedirect) {
        this.ignoreDefaultModelOnRedirect = ignoreDefaultModelOnRedirect;
    }

    public void setViewName(String viewName) {
        this.view = viewName;
    }

    public String getViewName() {
        return this.view instanceof String ? (String)this.view : null;
    }

    public void setView(Object view) {
        this.view = view;
    }

    public Object getView() {
        return this.view;
    }

    public boolean isViewReference() {
        return this.view instanceof String;
    }

    public ModelMap getModel() {
        if (this.useDefaultModel()) {
            return this.defaultModel;
        }
        return this.redirectModel != null ? this.redirectModel : new ModelMap();
    }

    private boolean useDefaultModel() {
        return !this.redirectModelScenario || this.redirectModel == null && !this.ignoreDefaultModelOnRedirect;
    }

    public ModelMap getDefaultModel() {
        return this.defaultModel;
    }

    public void setRedirectModel(ModelMap redirectModel) {
        this.redirectModel = redirectModel;
    }

    public void setRedirectModelScenario(boolean redirectModelScenario) {
        this.redirectModelScenario = redirectModelScenario;
    }

    public SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    public void setRequestHandled(boolean requestHandled) {
        this.requestHandled = requestHandled;
    }

    public boolean isRequestHandled() {
        return this.requestHandled;
    }

    public ModelAndViewContainer addAttribute(String name, Object value) {
        this.getModel().addAttribute(name, value);
        return this;
    }

    public ModelAndViewContainer addAttribute(Object value) {
        this.getModel().addAttribute(value);
        return this;
    }

    public ModelAndViewContainer addAllAttributes(Map<String, ?> attributes) {
        this.getModel().addAllAttributes(attributes);
        return this;
    }

    public ModelAndViewContainer mergeAttributes(Map<String, ?> attributes) {
        this.getModel().mergeAttributes(attributes);
        return this;
    }

    public ModelAndViewContainer removeAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.getModel().remove(key);
            }
        }
        return this;
    }

    public boolean containsAttribute(String name) {
        return this.getModel().containsAttribute(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ModelAndViewContainer: ");
        if (!this.isRequestHandled()) {
            if (this.isViewReference()) {
                sb.append("reference to view with name '").append(this.view).append("'");
            } else {
                sb.append("View is [").append(this.view).append(']');
            }
            if (this.useDefaultModel()) {
                sb.append("; default model ");
            } else {
                sb.append("; redirect model ");
            }
            sb.append(this.getModel());
        } else {
            sb.append("Request handled directly");
        }
        return sb.toString();
    }
}

