/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.stockquote;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.stockquote.Stock;
import org.wso2.msf4j.stockquote.Stocks;

@Path(value="/stockquote")
@Component(name="org.wso2.msf4j.stockquote.StockQuoteService", service={Microservice.class}, immediate=true)
public class StockQuoteService
implements Microservice {
    private static final Logger log = LoggerFactory.getLogger(StockQuoteService.class);
    private Map<String, Stock> stockQuotes = new HashMap<String, Stock>();

    public StockQuoteService() {
        this.stockQuotes.put("IBM", new Stock("IBM", "International Business Machines", 149.62, 150.78, 149.18));
        this.stockQuotes.put("GOOG", new Stock("GOOG", "Alphabet Inc.", 652.3, 657.81, 643.15));
        this.stockQuotes.put("AMZN", new Stock("AMZN", "Amazon.com", 548.9, 553.2, 543.1));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
    }

    @GET
    @Path(value="/{symbol}")
    @Produces(value={"application/json", "text/xml"})
    public Response getQuote(@PathParam(value="symbol") String symbol) {
        Stock stock = this.stockQuotes.get(symbol);
        return stock == null ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.status((Response.Status)Response.Status.OK).entity((Object)stock).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public void addStock(Stock stock) {
        this.stockQuotes.put(stock.getSymbol(), stock);
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json", "text/xml"})
    public Stocks getAllStocks() {
        return new Stocks(this.stockQuotes.values());
    }

    public String toString() {
        return "StockQuoteService-OSGi-bundle";
    }
}

