/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.zipkintracing;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.EmptySpanCollectorMetricsHandler;
import com.github.kristofa.brave.ServerRequestAdapter;
import com.github.kristofa.brave.ServerRequestInterceptor;
import com.github.kristofa.brave.ServerResponseAdapter;
import com.github.kristofa.brave.ServerResponseInterceptor;
import com.github.kristofa.brave.SpanCollector;
import com.github.kristofa.brave.SpanCollectorMetricsHandler;
import com.github.kristofa.brave.http.DefaultSpanNameProvider;
import com.github.kristofa.brave.http.HttpResponse;
import com.github.kristofa.brave.http.HttpServerRequest;
import com.github.kristofa.brave.http.HttpServerRequestAdapter;
import com.github.kristofa.brave.http.HttpServerResponseAdapter;
import com.github.kristofa.brave.http.HttpSpanCollector;
import com.github.kristofa.brave.http.SpanNameProvider;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.zipkintracing.TraceableHttpServerRequest;
import org.wso2.msf4j.analytics.zipkintracing.TraceableHttpServerResponse;

public class MSF4JZipkinTracingInterceptor
implements Interceptor {
    private final ServerRequestInterceptor reqInterceptor;
    private final ServerResponseInterceptor respInterceptor;
    private static final String RESPONDER_ATTRIBUTE = "responder-attribute";

    public MSF4JZipkinTracingInterceptor(String microServiceName) {
        this(microServiceName, "http://0.0.0.0:9411");
    }

    public MSF4JZipkinTracingInterceptor(String microServiceName, String zipkinUrl) {
        Brave.Builder builder = new Brave.Builder(microServiceName);
        builder.spanCollector((SpanCollector)HttpSpanCollector.create((String)zipkinUrl, (SpanCollectorMetricsHandler)new EmptySpanCollectorMetricsHandler()));
        Brave brave = builder.build();
        this.reqInterceptor = brave.serverRequestInterceptor();
        this.respInterceptor = brave.serverResponseInterceptor();
    }

    public boolean preCall(Request request, Response responder, ServiceMethodInfo serviceMethodInfo) throws Exception {
        serviceMethodInfo.setAttribute(RESPONDER_ATTRIBUTE, (Object)responder);
        TraceableHttpServerRequest req = new TraceableHttpServerRequest(request);
        HttpServerRequestAdapter reqAdapter = new HttpServerRequestAdapter((HttpServerRequest)req, (SpanNameProvider)new DefaultSpanNameProvider());
        this.reqInterceptor.handle((ServerRequestAdapter)reqAdapter);
        return true;
    }

    public void postCall(Request request, int status, ServiceMethodInfo serviceMethodInfo) throws Exception {
        TraceableHttpServerResponse httpResponse = new TraceableHttpServerResponse((Response)serviceMethodInfo.getAttribute(RESPONDER_ATTRIBUTE));
        HttpServerResponseAdapter adapter = new HttpServerResponseAdapter((HttpResponse)httpResponse);
        this.respInterceptor.handle((ServerResponseAdapter)adapter);
    }
}

