/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.performance.common.jtl.splitter;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.wso2.performance.common.jtl.splitter.JTLFileValidator;
import org.wso2.performance.common.jtl.splitter.StatCalculator;
import org.wso2.performance.common.jtl.splitter.SummaryStats;
import org.wso2.performance.common.jtl.splitter.WarmupTimeValidator;

public final class JTLSplitter {
    @Parameter(names={"-t", "--warmup-time"}, description="Warmup Time", required=true, validateWith={WarmupTimeValidator.class})
    private int warmupTime;
    @Parameter(names={"-u", "--time-unit"}, description="Time Unit")
    private TimeUnit timeUnit = TimeUnit.MINUTES;
    @Parameter(names={"-f", "--jtlfile"}, description="JTL File", required=true, validateValueWith={JTLFileValidator.class})
    private File jtlFile;
    @Parameter(names={"-d", "--delete-jtl-file-on-exit"}, description="Delete JTL File on exit")
    private boolean deleteJTLFileOnExit;
    @Parameter(names={"-p", "--progress"}, description="Show progress")
    private boolean showProgress;
    @Parameter(names={"-s", "--summarize"}, description="Summarize results")
    private boolean summarize;
    @Parameter(names={"-n", "--precision"}, description="Precision to use in statistics")
    private int precision = 2;
    @Parameter(names={"-h", "--help"}, description="Display Help", help=true)
    private boolean help = false;
    private static PrintStream errorOutput = System.err;
    private static PrintStream standardOutput = System.out;

    public static void main(String[] args) {
        JTLSplitter jtlSplitter = new JTLSplitter();
        JCommander jcmdr = new JCommander(jtlSplitter);
        jcmdr.setProgramName(JTLSplitter.class.getSimpleName());
        try {
            jcmdr.parse(args);
        }
        catch (Exception e) {
            errorOutput.println(e.getMessage());
            return;
        }
        if (jtlSplitter.help) {
            jcmdr.usage();
            return;
        }
        jtlSplitter.splitJTL();
    }

    private void splitJTL() {
        Throwable throwable;
        Throwable throwable2;
        long startTime = System.nanoTime();
        Path jtlPath = this.jtlFile.toPath();
        String fileName = jtlPath.getFileName().toString();
        String outputFilePrefix = fileName.substring(0, fileName.length() - 4);
        Path warmupJTLFile = jtlPath.resolveSibling(outputFilePrefix + "-warmup.jtl");
        Path measurementJTLFile = jtlPath.resolveSibling(outputFilePrefix + "-measurement.jtl");
        LinkedHashMap<String, StatCalculator> warmupStatCalculators = new LinkedHashMap<String, StatCalculator>();
        LinkedHashMap<String, StatCalculator> measurementStatCalculators = new LinkedHashMap<String, StatCalculator>();
        Path warmupSummaryJsonFile = jtlPath.resolveSibling(outputFilePrefix + "-warmup-summary.json");
        Path measurementSummaryJsonFile = jtlPath.resolveSibling(outputFilePrefix + "-measurement-summary.json");
        standardOutput.format("Splitting %s file into %s and %s.%n", fileName, warmupJTLFile.getFileName(), measurementJTLFile.getFileName());
        standardOutput.format("Warmup Time: %d %s%n", new Object[]{this.warmupTime, this.timeUnit});
        if (this.summarize) {
            standardOutput.format("Summarization is enabled. Summary statistics will be written to %s and %s.%n", warmupSummaryJsonFile.getFileName(), measurementSummaryJsonFile.getFileName());
        }
        long timeLimit = this.timeUnit.toMillis(this.warmupTime);
        try {
            throwable2 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(this.jtlFile));){
                throwable = null;
                try (BufferedWriter bwWarmup = new BufferedWriter(new FileWriter(warmupJTLFile.toFile()));
                     BufferedWriter bwMeasurement2 = new BufferedWriter(new FileWriter(measurementJTLFile.toFile()));){
                    String line = br.readLine();
                    if (line != null) {
                        bwWarmup.write(line);
                        bwWarmup.newLine();
                        bwMeasurement2.write(line);
                        bwMeasurement2.newLine();
                    }
                    long startTimestamp = Long.MAX_VALUE;
                    long lineNumber = 1L;
                    if (this.showProgress) {
                        standardOutput.print("Started splitting...\r");
                    }
                    int minimumColumns = 11;
                    int maximumColumns = 17;
                    block53: while ((line = br.readLine()) != null) {
                        LinkedHashMap<String, StatCalculator> statCalculatorMap;
                        long diff;
                        long timestamp;
                        int end;
                        ++lineNumber;
                        int i = 0;
                        String[] values = new String[17];
                        int pos = 0;
                        while ((end = line.indexOf(44, pos)) >= 0) {
                            if (i < 16) {
                                values[i++] = line.substring(pos, end);
                                pos = end + 1;
                                continue;
                            }
                            errorOutput.format("WARNING: Line %d has more columns than expected: %s%n", lineNumber, line);
                            continue block53;
                        }
                        values[i] = line.substring(pos);
                        if (this.showProgress && lineNumber % 10000L == 0L) {
                            standardOutput.print("Processed " + lineNumber + " lines.\r");
                        }
                        if (i < 11) {
                            errorOutput.format("WARNING: Line %d has less columns than expected: %s%n", lineNumber, line);
                            continue;
                        }
                        try {
                            timestamp = Long.parseLong(values[0]);
                        }
                        catch (Throwable parseError) {
                            errorOutput.format("ERROR: Failed to parse timestamp in line %d: %s%n", lineNumber, line);
                            throw new RuntimeException(parseError);
                        }
                        if (startTimestamp > timestamp) {
                            startTimestamp = timestamp;
                        }
                        if ((diff = timestamp - startTimestamp) <= timeLimit) {
                            statCalculatorMap = warmupStatCalculators;
                            bwWarmup.write(line);
                            bwWarmup.newLine();
                        } else {
                            statCalculatorMap = measurementStatCalculators;
                            bwMeasurement2.write(line);
                            bwMeasurement2.newLine();
                        }
                        if (!this.summarize) continue;
                        try {
                            String label = values[2];
                            StatCalculator statCalculator = (StatCalculator)statCalculatorMap.get(label);
                            if (statCalculator == null) {
                                statCalculator = new StatCalculator(this.precision);
                                statCalculatorMap.put(label, statCalculator);
                            }
                            statCalculator.addSample(timestamp, Integer.parseInt(values[1]), Boolean.parseBoolean(values[7]), Integer.parseInt(values[9]), Integer.parseInt(values[10]));
                        }
                        catch (Throwable parseError) {
                            errorOutput.format("ERROR: Failed to parse values in line %d: %s%n", lineNumber, line);
                            throw new RuntimeException(parseError);
                        }
                    }
                    if (this.deleteJTLFileOnExit) {
                        this.jtlFile.deleteOnExit();
                    }
                }
                catch (Throwable bwMeasurement2) {
                    throwable = bwMeasurement2;
                    throw bwMeasurement2;
                }
            }
            catch (Throwable bwWarmup) {
                throwable2 = bwWarmup;
                throw bwWarmup;
            }
        }
        catch (IOException e) {
            errorOutput.println(e.getMessage());
        }
        if (this.summarize) {
            try {
                throwable2 = null;
                try (BufferedWriter bwWarmupSummary = new BufferedWriter(new FileWriter(warmupSummaryJsonFile.toFile()));){
                    throwable = null;
                    try (BufferedWriter bwMeasurementSummary = new BufferedWriter(new FileWriter(measurementSummaryJsonFile.toFile()));){
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        gson.toJson(this.getSummaryStats(warmupStatCalculators), (Appendable)bwWarmupSummary);
                        gson.toJson(this.getSummaryStats(measurementStatCalculators), (Appendable)bwMeasurementSummary);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable throwable4) {
                    throwable2 = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException e) {
                errorOutput.println(e.getMessage());
            }
        }
        long elapsed = System.nanoTime() - startTime;
        standardOutput.format("Done in %d min, %d sec.                           %n", TimeUnit.NANOSECONDS.toMinutes(elapsed), TimeUnit.NANOSECONDS.toSeconds(elapsed) - TimeUnit.MINUTES.toSeconds(TimeUnit.NANOSECONDS.toMinutes(elapsed)));
    }

    private Map<String, SummaryStats> getSummaryStats(Map<String, StatCalculator> statCalculatorMap) {
        LinkedHashMap<String, SummaryStats> summaryStatsMap = new LinkedHashMap<String, SummaryStats>(statCalculatorMap.size());
        statCalculatorMap.forEach((label, statCalculator) -> summaryStatsMap.put((String)label, statCalculator.calculate()));
        return summaryStatsMap;
    }
}

