/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.performance.common.jtl.splitter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.wso2.performance.common.jtl.splitter.SummaryStats;

public class StatCalculator {
    private final Recorder recorder;
    private final Histogram intervalHistogram;
    private final Histogram accumulatedHistogram;
    private long startTimestamp = Long.MAX_VALUE;
    private long endTimestamp;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long errors;
    private long totalBytes;
    private long totalSentBytes;

    public StatCalculator(int precision) {
        this.recorder = new Recorder(precision);
        this.intervalHistogram = new Histogram(precision);
        this.accumulatedHistogram = new Histogram(precision);
    }

    public synchronized void addSample(long timestamp, int elapsed, boolean success, int bytes, int sentBytes) {
        long endTimestamp;
        this.recorder.recordValue(elapsed);
        if (this.startTimestamp > timestamp) {
            this.startTimestamp = timestamp;
        }
        if (this.endTimestamp < (endTimestamp = timestamp + (long)elapsed)) {
            this.endTimestamp = endTimestamp;
        }
        if (this.min > (long)elapsed) {
            this.min = elapsed;
        }
        if (this.max < (long)elapsed) {
            this.max = elapsed;
        }
        if (!success) {
            ++this.errors;
        }
        this.totalBytes += (long)bytes;
        this.totalSentBytes += (long)sentBytes;
    }

    public synchronized SummaryStats calculate() {
        this.recorder.getIntervalHistogramInto(this.intervalHistogram);
        this.accumulatedHistogram.add(this.intervalHistogram);
        long samples = this.accumulatedHistogram.getTotalCount();
        if (samples == 0L) {
            return new SummaryStats(-1L, -1L, new BigDecimal(-1), new BigDecimal(-1), -1L, -1L, new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1), new BigDecimal(-1));
        }
        RoundingMode roundingMode = RoundingMode.HALF_EVEN;
        double duration = (double)(this.endTimestamp - this.startTimestamp) / 1000.0;
        return new SummaryStats(samples, this.errors, new BigDecimal(samples > 0L ? (double)this.errors / (double)samples * 100.0 : 0.0).setScale(2, roundingMode), new BigDecimal((double)samples / duration).setScale(2, roundingMode), this.min, this.max, new BigDecimal(this.accumulatedHistogram.getMean()).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getStdDeviation()).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(50.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(75.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(90.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(95.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(98.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(99.0)).setScale(2, roundingMode), new BigDecimal(this.accumulatedHistogram.getValueAtPercentile(99.9)).setScale(2, roundingMode), new BigDecimal((double)this.totalBytes / 1024.0 / duration).setScale(2, roundingMode), new BigDecimal((double)this.totalSentBytes / 1024.0 / duration).setScale(2, roundingMode));
    }
}

