/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.pwprovider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.pwprovider.PasswordProvider;
import org.wso2.pwprovider.PasswordProviderException;
import sun.misc.BASE64Decoder;

public class DefaultPasswordProvider
extends Thread
implements PasswordProvider {
    private static Log log = LogFactory.getLog(DefaultPasswordProvider.class);
    private static String keyStorePassWord;
    private static String privateKeyPassWord;
    private static String keyStoreName;
    private static String keyAlias;
    private static String keyType;
    private static String carbonHome;
    private static File keyDataFile;
    private boolean stopThread = false;

    public void init(Properties properties) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolve(String encryptedPassword) {
        block35: {
            block36: {
                block39: {
                    block38: {
                        String textFileName_tmp;
                        block37: {
                            String textFileName;
                            log.info((Object)"Password is decrypted using DefaultPasswordProvider");
                            String xpathOfKeyLocation = "//KeyStore/KeyStoreName/node()";
                            String xpathOfType = "//KeyStore/Type/node()";
                            String xpathOfAlias = "//KeyStore/KeyAlias/node()";
                            String xpathOfKeyStorePass = "//KeyStore/KeyStorePassword/node()";
                            String xpathOfKeyPass = "//KeyStore/PrivateKeyPassword/node()";
                            String xpathOfPrimaryKeyLocation = "//Server/Security/KeyStore/Location/node()";
                            String xpathOfPrimaryKeyType = "//Server/Security/KeyStore/Type/node()";
                            String xpathOfPrimaryKeyAlias = "//Server/Security/KeyStore/KeyAlias/node()";
                            carbonHome = System.getProperty("carbon.home");
                            String osName = System.getProperty("os.name");
                            if (osName.toLowerCase().indexOf("win") == -1) {
                                textFileName = "password";
                                textFileName_tmp = "password-tmp";
                            } else {
                                textFileName = "password.txt";
                                textFileName_tmp = "password-tmp.txt";
                            }
                            String keyStorePrivateKeyPass = System.getProperty("private.keyStore.password");
                            boolean samePrivateKeyStorePass = keyStorePrivateKeyPass == null || !keyStorePrivateKeyPass.trim().equals("false");
                            keyDataFile = new File(carbonHome + File.separator + "resources" + File.separator + "security" + File.separator + textFileName);
                            DefaultPasswordProvider passwordHideThread = new DefaultPasswordProvider();
                            if (keyStorePassWord != null && !keyStorePassWord.equals("") && privateKeyPassWord != null && !privateKeyPassWord.equals("")) break block35;
                            passwordHideThread.start();
                            BufferedReader input1 = new BufferedReader(new InputStreamReader(System.in));
                            if (samePrivateKeyStorePass) {
                                log.info((Object)"Enter Primary KeyStore and Private Key Password of Carbon Server :");
                                try {
                                    keyStorePassWord = input1.readLine();
                                    this.stopThread = false;
                                    privateKeyPassWord = keyStorePassWord;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                log.info((Object)"Enter Primary KeyStore Password of Carbon Server :");
                                try {
                                    keyStorePassWord = input1.readLine();
                                    this.stopThread = false;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                BufferedReader input2 = new BufferedReader(new InputStreamReader(System.in));
                                log.info((Object)"Enter Private Key Password of Carbon Server :");
                                try {
                                    privateKeyPassWord = input2.readLine();
                                    this.stopThread = false;
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (keyStorePassWord != null && !keyStorePassWord.equals("") && privateKeyPassWord != null && !privateKeyPassWord.equals("")) break block36;
                            if (!keyDataFile.isFile()) break block37;
                            keyStorePassWord = this.readPassword(keyDataFile, "keyStore");
                            privateKeyPassWord = this.readPassword(keyDataFile, "privateKey");
                            if (!(keyStorePassWord == null && keyStorePassWord.equals("") || privateKeyPassWord != null && !privateKeyPassWord.equals(""))) {
                                privateKeyPassWord = keyStorePassWord;
                            }
                            keyStoreName = this.getPrimaryKeyData("//Server/Security/KeyStore/Location/node()");
                            keyAlias = this.getPrimaryKeyData("//Server/Security/KeyStore/KeyAlias/node()");
                            keyType = this.getPrimaryKeyData("//Server/Security/KeyStore/Type/node()");
                            keyStoreName = carbonHome + keyStoreName.substring(keyStoreName.indexOf(125) + 1);
                            if (!this.renameConfigFile(textFileName_tmp)) {
                                try {
                                    throw new PasswordProviderException("Can not rename Password config File");
                                }
                                catch (PasswordProviderException e) {
                                    e.printStackTrace();
                                }
                            }
                            break block35;
                        }
                        keyDataFile = new File(carbonHome + File.separator + "resources" + File.separator + "security" + File.separator + textFileName_tmp);
                        if (!keyDataFile.exists()) break block38;
                        keyStorePassWord = this.readPassword(keyDataFile, "keyStore");
                        privateKeyPassWord = this.readPassword(keyDataFile, "privateKey");
                        if (!(keyStorePassWord == null && keyStorePassWord.equals("") || privateKeyPassWord != null && !privateKeyPassWord.equals(""))) {
                            privateKeyPassWord = keyStorePassWord;
                        }
                        keyStoreName = this.getPrimaryKeyData("//Server/Security/KeyStore/Location/node()");
                        keyAlias = this.getPrimaryKeyData("//Server/Security/KeyStore/KeyAlias/node()");
                        keyType = this.getPrimaryKeyData("//Server/Security/KeyStore/Type/node()");
                        keyStoreName = carbonHome + keyStoreName.substring(keyStoreName.indexOf(125) + 1);
                        if (!this.deleteConfigFile()) {
                            try {
                                throw new PasswordProviderException("Can not delete Password config File");
                            }
                            catch (PasswordProviderException e) {
                                e.printStackTrace();
                            }
                        }
                        break block35;
                    }
                    keyDataFile = new File(carbonHome + File.separator + "resources" + File.separator + "security" + File.separator + "key-password.xml");
                    if (!keyDataFile.exists()) break block39;
                    keyStorePassWord = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyStorePassword/node()");
                    privateKeyPassWord = this.getDataFromConfigFile(keyDataFile, "//KeyStore/PrivateKeyPassword/node()");
                    keyStoreName = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyStoreName/node()");
                    keyType = this.getDataFromConfigFile(keyDataFile, "//KeyStore/Type/node()");
                    keyAlias = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyAlias/node()");
                    if (!this.renameConfigFile("key-password-tmp.xml")) {
                        try {
                            throw new PasswordProviderException("Can not rename Password config File");
                        }
                        catch (PasswordProviderException e) {
                            e.printStackTrace();
                        }
                    }
                    break block35;
                }
                keyDataFile = new File(carbonHome + File.separator + "resources" + File.separator + "security" + File.separator + "key-password-tmp.xml");
                if (keyDataFile.exists()) {
                    keyStorePassWord = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyStorePassword/node()");
                    privateKeyPassWord = this.getDataFromConfigFile(keyDataFile, "//KeyStore/PrivateKeyPassword/node()");
                    keyStoreName = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyStoreName/node()");
                    keyType = this.getDataFromConfigFile(keyDataFile, "//KeyStore/Type/node()");
                    keyAlias = this.getDataFromConfigFile(keyDataFile, "//KeyStore/KeyAlias/node()");
                    if (!this.deleteConfigFile()) {
                        try {
                            throw new PasswordProviderException("Can not delete Password config File");
                        }
                        catch (PasswordProviderException e) {
                            e.printStackTrace();
                        }
                    }
                    break block35;
                } else {
                    try {
                        throw new PasswordProviderException("Can not find Password config File in default location");
                    }
                    catch (PasswordProviderException e) {
                        e.printStackTrace();
                        break block35;
                    }
                }
            }
            if (keyStoreName == null || keyStoreName.equals("")) {
                keyStoreName = this.getPrimaryKeyData("//Server/Security/KeyStore/Location/node()");
                keyStoreName = carbonHome + keyStoreName.substring(keyStoreName.indexOf(125) + 1);
            }
            if (keyAlias == null || keyAlias.equals("")) {
                keyAlias = this.getPrimaryKeyData("//Server/Security/KeyStore/KeyAlias/node()");
            }
            if (keyType == null || keyType.equals("")) {
                keyType = this.getPrimaryKeyData("//Server/Security/KeyStore/Type/node()");
            }
        }
        byte[] decrypted = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(keyType);
            FileInputStream in = new FileInputStream(keyStoreName);
            keyStore.load(in, keyStorePassWord.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, privateKeyPassWord.toCharArray());
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            decrypted = cipher.doFinal(new BASE64Decoder().decodeBuffer(encryptedPassword));
            return new String(decrypted);
        }
        catch (Exception e) {
            try {
                throw new PasswordProviderException("Error loading key store for decrypting passwords in config files ", e);
            }
            catch (PasswordProviderException e1) {
                e1.printStackTrace();
            }
        }
        return new String(decrypted);
    }

    private String getDataFromConfigFile(File fileName, String xpath) {
        String nodeValue = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(fileName);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            XPathExpression xpathEx = xp.compile(xpath);
            Node text = (Node)xpathEx.evaluate(doc.getDocumentElement(), XPathConstants.NODE);
            nodeValue = text.getNodeValue();
        }
        catch (Exception e) {
            try {
                throw new PasswordProviderException("Error reading key store data from key-password.xml file ", e);
            }
            catch (PasswordProviderException e1) {
                e1.printStackTrace();
            }
        }
        return nodeValue;
    }

    private String getPrimaryKeyData(String xpath) {
        String carbonConfigFile = carbonHome + File.separator + "repository" + File.separator + "conf" + File.separator + "carbon.xml";
        String nodeValue = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(carbonConfigFile);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            XPathExpression xpathEx = xp.compile(xpath);
            Node text = (Node)xpathEx.evaluate(doc.getDocumentElement(), XPathConstants.NODE);
            nodeValue = text.getNodeValue();
        }
        catch (Exception e) {
            try {
                throw new PasswordProviderException("Error reading primary key store data from carbon.xml file ", e);
            }
            catch (PasswordProviderException e1) {
                e1.printStackTrace();
            }
        }
        return nodeValue;
    }

    private String readPassword(File file, String passwordOf) {
        String stringLine = null;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            if (passwordOf.equals("keyStore")) {
                stringLine = br.readLine();
            }
            if (passwordOf.equals("privateKey")) {
                stringLine = br.readLine();
                stringLine = br.readLine();
            }
            inputStream.close();
        }
        catch (Exception e) {
            try {
                throw new PasswordProviderException("Error reading password from text file ", e);
            }
            catch (PasswordProviderException e1) {
                e1.printStackTrace();
            }
        }
        return stringLine;
    }

    private boolean deleteConfigFile() {
        if (keyDataFile.exists()) {
            return keyDataFile.delete();
        }
        return false;
    }

    private boolean renameConfigFile(String fileName) {
        if (keyDataFile.exists()) {
            File newConfigFile = new File(carbonHome + File.separator + "resources" + File.separator + "security" + File.separator + fileName);
            return keyDataFile.renameTo(newConfigFile);
        }
        return false;
    }

    public void run() {
        this.stopThread = true;
        try {
            DefaultPasswordProvider.sleep(100L);
            while (this.stopThread) {
                System.out.print("\b ");
                DefaultPasswordProvider.sleep(1L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }
}

