/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.pwprovider;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.pwprovider.PasswordProvider;

public class PasswordManager {
    private static Log log = LogFactory.getLog(PasswordManager.class);
    private boolean initialized = false;
    private PasswordProvider passwordProvider;
    private final ArrayList<String> protectedTokens = new ArrayList();

    public void init(Properties properties) {
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SimplePasswordManager already has been started.");
            }
            return;
        }
        String provider = PasswordManager.getProperty(properties, "PasswordProvider", null);
        if (provider != null && !"".equals(provider)) {
            try {
                Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(provider);
                Object object = aClass.newInstance();
                if (!(object instanceof PasswordProvider)) {
                    PasswordManager.handleException("Invalid class as PasswordProvider : Class Name : " + provider);
                } else {
                    this.passwordProvider = (PasswordProvider)object;
                }
                this.passwordProvider.init(properties);
            }
            catch (ClassNotFoundException e) {
                PasswordManager.handleException("A PasswordProvider cannot be found for class name : " + provider, e);
            }
            catch (IllegalAccessException e) {
                PasswordManager.handleException("Error creating a instance from class : " + provider, e);
            }
            catch (InstantiationException e) {
                PasswordManager.handleException("Error creating a instance from class : " + provider, e);
            }
            this.initialized = true;
        } else {
            log.warn((Object)"isPasswordEncrypted has been set to true. But there is no a PasswordProvider has been configured.");
        }
    }

    public String resolve(String encryptedPassword) {
        if (encryptedPassword == null || "".equals(encryptedPassword)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given Encrypted Password is empty or null. Returning itself");
            }
            return encryptedPassword;
        }
        if (!this.initialized || this.passwordProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SimplePasswordManager has not been initialized. Returning itself");
            }
            return encryptedPassword;
        }
        return this.passwordProvider.resolve(encryptedPassword);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new RuntimeException(msg, e);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new RuntimeException(msg);
    }

    private static String getProperty(Properties properties, String name, String defaultValue) {
        String result = properties.getProperty(name);
        if ((result == null || result.length() == 0 || "".equals(result)) && defaultValue != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The name with ' " + name + " ' cannot be found. " + "Using default value " + defaultValue));
            }
            result = defaultValue;
        }
        if (result != null) {
            return result.trim();
        }
        return defaultValue;
    }

    public void addProtectedToken(String token) {
        if (token != null && !"".equals(token)) {
            this.protectedTokens.add(token.trim());
        }
    }

    public boolean isTokenProtected(String token) {
        return token != null && !"".equals(token) && this.protectedTokens.contains(token.trim());
    }

    public void shutDown() {
        this.initialized = false;
        this.passwordProvider = null;
        this.protectedTokens.clear();
    }
}

