/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.pwprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.wso2.pwprovider.PasswordManager;

public class PasswordManagerFactory {
    public static PasswordManager create(OMElement config, boolean isCapLetter) {
        String value;
        OMElement protectedTokensElement;
        OMElement isEncryptedElement;
        QName protectedTokensQName;
        QName isEncryptedQName;
        QName passwordProviderQName;
        OMElement child;
        QName passwordManagerQName;
        String nsPrefix;
        PasswordManager passwordManager = new PasswordManager();
        QName parentQName = config.getQName();
        String nsURI = parentQName != null ? parentQName.getNamespaceURI() : "";
        String string = nsPrefix = parentQName != null ? parentQName.getPrefix() : "";
        if (!isCapLetter) {
            passwordManagerQName = new QName(nsURI, "passwordManager", nsPrefix);
            child = config.getFirstChildWithName(passwordManagerQName);
            if (child == null) {
                passwordManagerQName = new QName(nsURI, "PasswordManager", nsPrefix);
                isCapLetter = !isCapLetter;
            }
        } else {
            passwordManagerQName = new QName(nsURI, "PasswordManager", nsPrefix);
            child = config.getFirstChildWithName(passwordManagerQName);
            if (child == null) {
                passwordManagerQName = new QName(nsURI, "passwordManager", nsPrefix);
                boolean bl = isCapLetter = !isCapLetter;
            }
        }
        if (!isCapLetter) {
            passwordProviderQName = new QName(nsURI, "passwordProvider", nsPrefix);
            isEncryptedQName = new QName(nsURI, "isPasswordEncrypted", nsPrefix);
            protectedTokensQName = new QName(nsURI, "protectedTokens", nsPrefix);
        } else {
            passwordProviderQName = new QName(nsURI, "PasswordProvider", nsPrefix);
            isEncryptedQName = new QName(nsURI, "IsPasswordEncrypted", nsPrefix);
            protectedTokensQName = new QName(nsURI, "ProtectedTokens", nsPrefix);
        }
        child = config.getFirstChildWithName(passwordManagerQName);
        if (child == null) {
            return passwordManager;
        }
        OMElement passwordProviderElement = child.getFirstChildWithName(passwordProviderQName);
        Properties properties = new Properties();
        if (passwordProviderElement != null) {
            String passwordProvider = passwordProviderElement.getText();
            properties.put("PasswordProvider", passwordProvider);
        }
        if ((isEncryptedElement = child.getFirstChildWithName(isEncryptedQName)) != null) {
            String isEncrypted = isEncryptedElement.getText();
            if (isEncrypted == null || "".equals(isEncrypted)) {
                isEncrypted = "false";
            }
            properties.put("IsPasswordEncrypted", isEncrypted);
        }
        if (!properties.isEmpty() && !passwordManager.isInitialized()) {
            passwordManager.init(properties);
        }
        if (passwordManager.isInitialized() && (protectedTokensElement = child.getFirstChildWithName(protectedTokensQName)) != null && (value = protectedTokensElement.getText()) != null && value.trim().length() > 0) {
            ArrayList<String> protectedTokens = new ArrayList<String>(Arrays.asList(value.split(",")));
            for (String token : protectedTokens) {
                passwordManager.addProtectedToken(token);
            }
        }
        return passwordManager;
    }

    public static PasswordManager create(Properties properties, String prefix) {
        String protectedTokens;
        PasswordManager passwordManager = new PasswordManager();
        Properties passManProperties = new Properties();
        String passwordProvider = properties.getProperty(prefix + ".passwordProvider");
        if (passwordProvider != null && !"".equals(passwordProvider.trim())) {
            passManProperties.put("PasswordProvider", passwordProvider.trim());
        }
        if (!passManProperties.isEmpty() && !passwordManager.isInitialized()) {
            passwordManager.init(passManProperties);
        }
        if (passwordManager.isInitialized() && (protectedTokens = properties.getProperty(prefix + ".protectedTokens")) != null && !"".equals(protectedTokens.trim())) {
            ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : tokens) {
                passwordManager.addProtectedToken(token);
            }
        }
        return passwordManager;
    }

    public static PasswordManager create(NamedNodeMap namedNodeMap) {
        String protectedTokens;
        Node protectedTokensAttrib;
        String isPasswordEncrypted;
        Node isPasswordEncryptedAttrib;
        String passwordProvider;
        PasswordManager passwordManager = new PasswordManager();
        Properties properties = new Properties();
        Node passwordProviderAttrib = namedNodeMap.getNamedItem("passwordProvider");
        if (passwordProviderAttrib != null && (passwordProvider = passwordProviderAttrib.getNodeValue()) != null && passwordProvider.trim().length() > 0) {
            properties.put("PasswordProvider", passwordProvider.trim());
        }
        if ((isPasswordEncryptedAttrib = namedNodeMap.getNamedItem("isPasswordEncrypted")) != null && (isPasswordEncrypted = isPasswordEncryptedAttrib.getNodeValue()) != null && isPasswordEncrypted.trim().length() > 0) {
            properties.put("isPasswordEncrypted", isPasswordEncrypted.trim());
        }
        if (!properties.isEmpty() && !passwordManager.isInitialized()) {
            passwordManager.init(properties);
        }
        if ((protectedTokensAttrib = namedNodeMap.getNamedItem("protectedTokens")) != null && (protectedTokens = protectedTokensAttrib.getNodeValue()) != null && protectedTokens.trim().length() > 0) {
            ArrayList<String> protectedTokenList = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : protectedTokenList) {
                if (token == null || "".equals(token)) continue;
                passwordManager.addProtectedToken(token);
            }
        }
        return passwordManager;
    }
}

