/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault.secret.repository;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.BaseCipher;
import org.wso2.securevault.CipherFactory;
import org.wso2.securevault.CipherOperationMode;
import org.wso2.securevault.EncodingType;
import org.wso2.securevault.SecureVaultException;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.wso2.securevault.definition.CipherInformation;
import org.wso2.securevault.keystore.IdentityKeyStoreWrapper;
import org.wso2.securevault.keystore.KeyStoreWrapper;
import org.wso2.securevault.keystore.TrustKeyStoreWrapper;
import org.wso2.securevault.secret.SecretRepository;

public class FileBaseSecretRepository
implements SecretRepository {
    private static Log log = LogFactory.getLog(FileBaseSecretRepository.class);
    private static final String LOCATION = "location";
    private static final String KEY_STORE = "keyStore";
    private static final String DOT = ".";
    private static final String ALGORITHM = "algorithm";
    private static final String SYMMETRIC = "symmetric";
    private static final String ENCRYPTION_MODE = "encryptionMode";
    private static final String DEFAULT_ASYMMETRIC_ALGORITHM = "RSA";
    private static final String DEFAULT_SYMMETRIC_ALGORITHM = "AES/GCM/NoPadding";
    private static final int GCM_TAG_LENGTH = 128;
    private static final String TRUSTED = "trusted";
    private static final String DEFAULT_CONF_LOCATION = "cipher-text.properties";
    private SecretRepository parentRepository;
    private final Map<String, String> secrets = new HashMap<String, String>();
    private final Map<String, String> encryptedData = new HashMap<String, String>();
    private IdentityKeyStoreWrapper identity;
    private TrustKeyStoreWrapper trust;
    private boolean initialize = false;
    private static final String IV = "iv";
    private static final String CIPHER_TEXT = "cipherText";

    public FileBaseSecretRepository(IdentityKeyStoreWrapper identity, TrustKeyStoreWrapper trust) {
        this.identity = identity;
        this.trust = trust;
    }

    @Override
    public void init(Properties properties, String id) {
        String sb = id + DOT + LOCATION;
        String filePath = MiscellaneousUtil.getProperty(properties, sb, DEFAULT_CONF_LOCATION);
        Properties cipherProperties = MiscellaneousUtil.loadProperties(filePath);
        if (cipherProperties.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cipher texts cannot be loaded form : " + filePath));
            }
            return;
        }
        String encryptionMode = id + DOT + ENCRYPTION_MODE;
        boolean symmetricEncryptionEnabled = SYMMETRIC.equals(MiscellaneousUtil.getProperty(properties, encryptionMode, null));
        String sbTwo = id + DOT + ALGORITHM;
        String algorithm = MiscellaneousUtil.getProperty(properties, sbTwo, FileBaseSecretRepository.getDefaultAlgorithm(symmetricEncryptionEnabled));
        String buffer = ".keyStore";
        String keyStore = MiscellaneousUtil.getProperty(properties, buffer, null);
        KeyStoreWrapper keyStoreWrapper = TRUSTED.equals(keyStore) ? this.trust : this.identity;
        CipherInformation cipherInformation = new CipherInformation();
        cipherInformation.setAlgorithm(algorithm);
        cipherInformation.setCipherOperationMode(CipherOperationMode.DECRYPT);
        cipherInformation.setInType(EncodingType.BASE64);
        if (symmetricEncryptionEnabled) {
            cipherInformation.setType(SYMMETRIC);
        }
        BaseCipher baseCipher = CipherFactory.createCipher(cipherInformation, keyStoreWrapper);
        for (Object alias : cipherProperties.keySet()) {
            String decryptedText;
            String key = String.valueOf(alias);
            String encryptedText = cipherProperties.getProperty(key);
            this.encryptedData.put(key, encryptedText);
            if (encryptedText == null || "".equals(encryptedText.trim())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("There is no secret for the alias : " + alias));
                continue;
            }
            if (DEFAULT_SYMMETRIC_ALGORITHM.equals(algorithm)) {
                JsonObject jsonObject = this.getJsonObject(encryptedText.trim());
                byte[] cipherText = this.getValueFromJson(jsonObject, CIPHER_TEXT).getBytes();
                byte[] iv = Base64Utils.decode((String)this.getValueFromJson(jsonObject, IV));
                decryptedText = new String(baseCipher.decrypt(cipherText, new GCMParameterSpec(128, iv)));
            } else {
                byte[] cipherText = encryptedText.trim().getBytes();
                decryptedText = new String(baseCipher.decrypt(cipherText));
            }
            if (StringUtils.isEmpty((String)decryptedText)) {
                log.warn((Object)("Error decrypting secret for the alias : " + alias));
            }
            this.secrets.put(key, decryptedText);
        }
        this.initialize = true;
    }

    private JsonObject getJsonObject(String encryptedText) {
        try {
            String jsonString = new String(Base64Utils.decode((String)encryptedText));
            return JsonParser.parseString((String)jsonString).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            throw new SecureVaultException("Invalid encrypted text: JSON parsing failed.", log);
        }
    }

    private String getValueFromJson(JsonObject jsonObject, String value) {
        JsonElement jsonElement = jsonObject.get(value);
        if (jsonElement == null) {
            throw new SecureVaultException(String.format("Value \"%s\" not found in JSON", value), log);
        }
        return jsonElement.getAsString();
    }

    @Override
    public String getSecret(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.secrets.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        String secret = this.secrets.get(alias);
        if (secret == null || "".equals(secret)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return secret;
    }

    @Override
    public String getEncryptedData(String alias) {
        if (alias == null || "".equals(alias)) {
            return alias;
        }
        if (!this.initialize || this.encryptedData.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        String encryptedValue = this.encryptedData.get(alias);
        if (encryptedValue == null || "".equals(encryptedValue)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is no secret found for alias '" + alias + "' returning itself"));
            }
            return alias;
        }
        return encryptedValue;
    }

    @Override
    public void setParent(SecretRepository parent) {
        this.parentRepository = parent;
    }

    @Override
    public SecretRepository getParent() {
        return this.parentRepository;
    }

    private static String getDefaultAlgorithm(boolean isSymmetric) {
        return isSymmetric ? DEFAULT_SYMMETRIC_ALGORITHM : DEFAULT_ASYMMETRIC_ALGORITHM;
    }
}

