/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.performance;

import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public class SimpleFilterMultipleQueryPerformance {
    private static int count = 0;
    private static volatile long start = System.currentTimeMillis();

    public static void main(String[] args) throws InterruptedException {
        SiddhiManager siddhiManager = new SiddhiManager();
        String executionPlan = "define stream cseEventStream (symbol string, price float, volume int);define stream cseEventStream2 (symbol string, price float, volume int);@info(name = 'query1') from cseEventStream[70 > price] select * insert into outputStream ;@info(name = 'query2') from cseEventStream[volume > 90] select * insert into outputStream ;";
        ExecutionPlanRuntime executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(executionPlan);
        executionPlanRuntime.addCallback("outputStream", new StreamCallback(){
            private long chunk = 0L;
            private long prevCount = 0L;

            public void receive(Event[] events) {
                count += events.length;
                long currentChunk = count / 2000000;
                if (currentChunk != this.chunk) {
                    long end = System.currentTimeMillis();
                    double tp = (double)((long)count - this.prevCount) * 1000.0 / (double)(end - start);
                    System.out.println("Throughput = " + tp + " Event/sec");
                    start = end;
                    this.chunk = currentChunk;
                    this.prevCount = count;
                }
            }
        });
        InputHandler inputHandler = executionPlanRuntime.getInputHandler("cseEventStream");
        executionPlanRuntime.start();
        while (true) {
            inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100});
            inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100});
            inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80});
            inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100});
            inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100});
            inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100});
            inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80});
            inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100});
        }
    }
}

