/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.performance;

import org.wso2.siddhi.core.ExecutionPlanRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputHandler;
import org.wso2.siddhi.core.stream.output.StreamCallback;

public class SimpleFilterMultipleQueryWithDisruptorPerformance {
    public static void main(String[] args) throws InterruptedException {
        SiddhiManager siddhiManager = new SiddhiManager();
        String executionPlan = "@plan:async define stream cseEventStream (symbol string, price float, volume int, timestamp long);@info(name = 'query1') from cseEventStream[70 > price] select * insert into outputStream ;@info(name = 'query2') from cseEventStream[volume > 90] select * insert into outputStream ;";
        ExecutionPlanRuntime executionPlanRuntime = siddhiManager.createExecutionPlanRuntime(executionPlan);
        executionPlanRuntime.addCallback("outputStream", new StreamCallback(){
            public int eventCount = 0;
            public int timeSpent = 0;
            long startTime = System.currentTimeMillis();

            public void receive(Event[] events) {
                for (Event event : events) {
                    ++this.eventCount;
                    this.timeSpent = (int)((long)this.timeSpent + (System.currentTimeMillis() - (Long)event.getData(3)));
                    if (this.eventCount % 1000000 != 0) continue;
                    System.out.println("Throughput : " + (long)(this.eventCount * 1000) / (System.currentTimeMillis() - this.startTime));
                    System.out.println("Time spent :  " + (double)this.timeSpent * 1.0 / (double)this.eventCount);
                    this.startTime = System.currentTimeMillis();
                    this.eventCount = 0;
                    this.timeSpent = 0;
                }
            }
        });
        InputHandler inputHandler = executionPlanRuntime.getInputHandler("cseEventStream");
        executionPlanRuntime.start();
        for (int i = 0; i <= 100; ++i) {
            EventPublisher eventPublisher = new EventPublisher(inputHandler);
            eventPublisher.run();
        }
    }

    static class EventPublisher
    implements Runnable {
        InputHandler inputHandler;

        EventPublisher(InputHandler inputHandler) {
            this.inputHandler = inputHandler;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(55.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"WSO2", Float.valueOf(100.0f), 80, System.currentTimeMillis()});
                        this.inputHandler.send(new Object[]{"IBM", Float.valueOf(75.6f), 100, System.currentTimeMillis()});
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

