/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.performance;

import java.util.Random;
import org.wso2.siddhi.core.SiddhiAppRuntime;
import org.wso2.siddhi.core.SiddhiManager;
import org.wso2.siddhi.core.stream.input.InputHandler;

public class NoIndexingTablePerformance {
    public static boolean output = false;
    public static int numberOfEventsStored = 1000000;
    public static int numberOfEventsChunked = 10000;

    public static void main(String[] args) throws InterruptedException {
        int i;
        SiddhiManager siddhiManager = new SiddhiManager();
        String siddhiApp = "define stream StockCheckStream (symbol string, company string, price float, volume int, timestamp long);define stream StockInputStream (symbol string, company string, price float, volume int); @PrimaryKey('symbol')@Index('volume')define table StockTable (symbol string, company string, price float, volume int);@info(name = 'query1') from StockInputStream select symbol, company, price, volume insert into StockTable ;@info(name = 'query2') from StockCheckStream join StockTable on StockCheckStream.symbol == StockTable.symbol and StockCheckStream.volume == StockTable.volume  select StockCheckStream.timestamp, StockCheckStream.symbol, StockCheckStream.company, StockCheckStream.price, StockCheckStream.volume insert into OutputStream ;";
        SiddhiAppRuntime siddhiAppRuntime = siddhiManager.createSiddhiAppRuntime(siddhiApp);
        System.out.println("Throughput\tLatency\tAvg Throughput\tAvg Latency");
        InputHandler stockCheckInputHandler = siddhiAppRuntime.getInputHandler("StockCheckStream");
        InputHandler stockInputInputHandler = siddhiAppRuntime.getInputHandler("StockInputStream");
        siddhiAppRuntime.start();
        Random random = new Random();
        for (i = 0; i < numberOfEventsStored; ++i) {
            stockInputInputHandler.send(new Object[]{"" + i, "" + i, Float.valueOf((float)i * 1.0f), i});
        }
        for (i = 0; i < 1; ++i) {
            EventPublisher eventPublisher = new EventPublisher(stockCheckInputHandler, random);
            eventPublisher.run();
        }
    }

    static class EventPublisher
    implements Runnable {
        public volatile double eventCount = 0.0;
        public volatile double timeSpent = 0.0;
        public volatile double totalThroughput = 0.0;
        public volatile double totalLatency = 0.0;
        public volatile double totalIterations = 0.0;
        volatile long startTime = System.currentTimeMillis();
        InputHandler inputHandler;
        private Random random;

        EventPublisher(InputHandler inputHandler, Random random) {
            this.inputHandler = inputHandler;
            this.random = random;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count = 100000000;
            while (count > 0) {
                --count;
                try {
                    int number = this.random.nextInt(numberOfEventsStored);
                    long startEventTime = System.currentTimeMillis();
                    this.inputHandler.send(new Object[]{"" + number, "" + number, Float.valueOf(this.random.nextFloat()), number, System.currentTimeMillis()});
                    if (output) continue;
                    this.eventCount += 1.0;
                    this.timeSpent += (double)(System.currentTimeMillis() - startEventTime);
                    if (this.eventCount % (double)numberOfEventsChunked != 0.0) continue;
                    EventPublisher eventPublisher = this;
                    synchronized (eventPublisher) {
                        this.totalIterations += 1.0;
                        if (this.totalIterations == 1001.0) {
                            System.exit(0);
                        }
                        double throughput = this.eventCount * 1000.0 / (double)(System.currentTimeMillis() - this.startTime);
                        double latency = this.timeSpent * 1.0 / this.eventCount;
                        this.totalThroughput += throughput;
                        this.totalLatency += latency;
                        System.out.println(throughput + "\t" + latency + "\t" + this.totalThroughput / this.totalIterations + "\t" + this.totalLatency / this.totalIterations);
                        this.startTime = System.currentTimeMillis();
                        this.eventCount = 0.0;
                        this.timeSpent = 0.0;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

