/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.sample.util;

import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

public class CustomFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
            Attribute.Type attributeType = expressionExecutor.getReturnType();
            if (attributeType == Attribute.Type.DOUBLE) {
                this.returnType = attributeType;
                continue;
            }
            if (attributeType == Attribute.Type.STRING || attributeType == Attribute.Type.BOOL) {
                throw new SiddhiAppCreationException("Plus cannot have parameters with types String or Bool");
            }
            this.returnType = Attribute.Type.LONG;
        }
    }

    protected Object execute(Object[] data) {
        if (this.returnType == Attribute.Type.DOUBLE) {
            double total = 0.0;
            for (Object aObj : data) {
                total += Double.parseDouble(String.valueOf(aObj));
            }
            return total;
        }
        long total = 0L;
        for (Object aObj : data) {
            total += Long.parseLong(String.valueOf(aObj));
        }
        return total;
    }

    protected Object execute(Object data) {
        if (this.returnType == Attribute.Type.DOUBLE) {
            return Double.parseDouble(String.valueOf(data));
        }
        return Long.parseLong(String.valueOf(data));
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }
}

