/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.annotation.processor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;

public class ValidationAnnotationProcessor
extends AbstractProcessor {
    private static final String STREAM_PROCESSOR_SUPER_CLASS = "org.wso2.siddhi.core.query.processor.stream.StreamProcessor";
    private static final String FUNCTION_EXECUTOR_SUPER_CLASS = "org.wso2.siddhi.core.executor.function.FunctionExecutor";
    private static final String ATTRIBUTE_AGGREGATOR_SUPER_CLASS = "org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator";
    private List<Class<? extends Annotation>> annotationsClasses;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.annotationsClasses = new ArrayList<Class<? extends Annotation>>();
        this.annotationsClasses.add(ReturnAttribute.class);
        this.annotationsClasses.add(Example.class);
        this.annotationsClasses.add(Parameter.class);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> annotationTypes = new HashSet<String>();
        for (Class<? extends Annotation> annotationClass : this.annotationsClasses) {
            annotationTypes.add(annotationClass.getCanonicalName());
        }
        return annotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    private void showBuildError(Element element, String message, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(message, args), element);
    }

    private void validateSuperClassInheritance(Element elementToValidate, String[] superClassNames) {
        TypeMirror superType = ((TypeElement)elementToValidate).getSuperclass();
        boolean isAChildClass = false;
        while (!"none".equals(superType.toString())) {
            Element superTypeElement = ((DeclaredType)superType).asElement();
            if (Arrays.asList(superClassNames).contains(superTypeElement.toString())) {
                isAChildClass = true;
                break;
            }
            superType = ((TypeElement)superTypeElement).getSuperclass();
        }
        if (!isAChildClass) {
            this.showBuildError(elementToValidate, "%s does not extend %s", elementToValidate.getSimpleName(), String.join((CharSequence)" or ", superClassNames));
        }
    }
}

