/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.definition;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.AttributeAlreadyExist;

public class StreamDefinition
implements ExecutionPlan {
    String streamId;
    List<Attribute> attributeList = new ArrayList<Attribute>();

    public StreamDefinition name(String streamId) {
        this.streamId = streamId;
        return this;
    }

    public StreamDefinition attribute(String attributeName, Attribute.Type type) {
        this.checkAttribute(attributeName);
        this.attributeList.add(new Attribute(attributeName, type));
        return this;
    }

    private void checkAttribute(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            throw new AttributeAlreadyExist(attributeName + " is already defined for with type " + (Object)((Object)attribute.getType()) + " for " + this.streamId);
        }
    }

    public String getStreamId() {
        return this.streamId;
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public Attribute.Type getAttributeType(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute.getType();
        }
        return null;
    }

    public int getAttributePosition(String attributeName) {
        int attributeListSize = this.attributeList.size();
        for (int i = 0; i < attributeListSize; ++i) {
            Attribute attribute = this.attributeList.get(i);
            if (!attribute.getName().equals(attributeName)) continue;
            return i;
        }
        return 0;
    }

    public String toString() {
        return "StreamDefinition{streamId='" + this.streamId + '\'' + ", attributeList=" + this.attributeList + '}';
    }

    public String[] getAttributeNameArray() {
        int attributeListSize = this.attributeList.size();
        String[] attributeNameArray = new String[attributeListSize];
        for (int i = 0; i < attributeListSize; ++i) {
            attributeNameArray[i] = this.attributeList.get(i).getName();
        }
        return attributeNameArray;
    }
}

