/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api;

import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.Query;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.JoinStream;
import org.wso2.siddhi.query.api.query.input.SingleStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.input.pattern.PatternStream;
import org.wso2.siddhi.query.api.query.input.pattern.element.PatternElement;
import org.wso2.siddhi.query.api.query.input.sequence.SequenceStream;
import org.wso2.siddhi.query.api.query.input.sequence.element.SequenceElement;
import org.wso2.siddhi.query.api.query.projection.Projector;

public abstract class QueryFactory {
    public static Query createQuery() {
        return new Query();
    }

    public static StreamDefinition createStreamDefinition() {
        return new StreamDefinition();
    }

    public static BasicStream inputStream(String streamId) {
        return new BasicStream(streamId, streamId);
    }

    public static Projector outputProjector() {
        return new Projector();
    }

    public static Stream joinStream(SingleStream leftStream, JoinStream.Type type, SingleStream rightStream, Condition onCompare, Constant within) {
        return new JoinStream(leftStream, type, rightStream, onCompare, within, JoinStream.EventTrigger.ALL);
    }

    public static Stream joinStream(SingleStream leftStream, JoinStream.Type type, SingleStream rightStream, Condition onCompare, Constant within, JoinStream.EventTrigger trigger) {
        return new JoinStream(leftStream, type, rightStream, onCompare, within, trigger);
    }

    public static Stream joinStream(SingleStream leftStream, JoinStream.Type type, SingleStream rightStream, Constant within) {
        return new JoinStream(leftStream, type, rightStream, null, within, JoinStream.EventTrigger.ALL);
    }

    public static Stream joinStream(SingleStream leftStream, JoinStream.Type type, SingleStream rightStream, Condition onCompare) {
        return new JoinStream(leftStream, type, rightStream, onCompare, null, JoinStream.EventTrigger.ALL);
    }

    public static Stream joinStream(SingleStream leftStream, JoinStream.Type type, SingleStream rightStream) {
        return new JoinStream(leftStream, type, rightStream, null, null, JoinStream.EventTrigger.ALL);
    }

    public static BasicStream inputStream(String streamReferenceId, String streamId) {
        return new BasicStream(streamReferenceId, streamId);
    }

    public static PatternStream patternStream(PatternElement patternElement) {
        return new PatternStream(patternElement, null);
    }

    public static PatternStream patternStream(PatternElement patternElement, Constant within) {
        return new PatternStream(patternElement, within);
    }

    public static SequenceStream sequenceStream(SequenceElement sequenceElement) {
        return new SequenceStream(sequenceElement, null);
    }

    public static SequenceStream sequenceStream(SequenceElement sequenceElement, Constant within) {
        return new SequenceStream(sequenceElement, within);
    }
}

