/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.List;
import org.wso2.siddhi.query.api.condition.AndCondition;
import org.wso2.siddhi.query.api.condition.BooleanCondition;
import org.wso2.siddhi.query.api.condition.Compare;
import org.wso2.siddhi.query.api.condition.NotCondition;
import org.wso2.siddhi.query.api.condition.OrCondition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventStream;

public abstract class Condition {
    public static Condition compare(Expression leftExpression, Operator operator, Expression rightExpression) {
        return new Compare(leftExpression, operator, rightExpression);
    }

    public static Condition and(Condition leftCondition, Condition rightCondition) {
        return new AndCondition(leftCondition, rightCondition);
    }

    public static Condition or(Condition leftCondition, Condition rightCondition) {
        return new OrCondition(leftCondition, rightCondition);
    }

    public static Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public static Condition bool(Expression expression) {
        return new BooleanCondition(expression);
    }

    abstract void validate(List<QueryEventStream> var1, String var2);

    public static enum Operator {
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN_EQUAL,
        EQUAL,
        NOT_EQUAL,
        CONTAINS,
        INSTANCE_OF;

    }
}

