/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.SingleStream;
import org.wso2.siddhi.query.api.query.input.WindowStream;
import org.wso2.siddhi.query.api.query.input.handler.Handler;
import org.wso2.siddhi.query.api.query.input.handler.Window;
import org.wso2.siddhi.query.api.query.input.pattern.element.PatternElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.SequenceElement;

public class BasicStream
implements SingleStream,
SequenceElement,
PatternElement {
    protected String streamId;
    protected StreamDefinition streamDefinition;
    protected String streamReferenceId;
    protected List<Handler> handlerList = new ArrayList<Handler>();
    protected boolean isCounterStream = false;

    protected BasicStream(String streamId, String streamReferenceId, List<Handler> handlerList) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
        this.handlerList = handlerList;
    }

    protected BasicStream(String streamId) {
        this(streamId, streamId);
    }

    public BasicStream(String streamReferenceId, String streamId) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
    }

    public BasicStream handler(Handler.Type type, String name, Object ... parameters) {
        this.handlerList.add(new Handler(name, type, parameters));
        return this;
    }

    public BasicStream addHandler(Handler handler) {
        this.handlerList.add(handler);
        return this;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public BasicStream setStreamReferenceId(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    @Override
    public List<Handler> getHandlerList() {
        return this.handlerList;
    }

    public BasicStream handler(Condition filterCondition) {
        this.handlerList.add(new Handler(null, Handler.Type.FILTER, new Object[]{filterCondition}));
        return this;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.streamId);
        return list;
    }

    public void setCounterStream(boolean counterStream) {
        this.isCounterStream = counterStream;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        this.streamDefinition = streamDefinitionMap.get(this.streamId);
        QueryEventStream queryEventStream = new QueryEventStream(this.streamId, this.streamReferenceId, this.streamDefinition);
        queryEventStream.setCounterStream(this.isCounterStream);
        queryEventStreams.add(queryEventStream);
        return queryEventStreams;
    }

    public SingleStream window(String name, Object ... parameters) {
        return new WindowStream(this, new Window(name, parameters));
    }

    public SingleStream setWindow(Window window) {
        return new WindowStream(this, window);
    }
}

