/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.Stream;

public class JoinStream
implements Stream {
    private Stream leftStream;
    private Type type;
    private Stream rightStream;
    private Condition onCompare;
    private EventTrigger trigger;
    private Constant within;

    public JoinStream(Stream leftStream, Type type, Stream rightStream, Condition onCompare, Constant within, EventTrigger trigger) {
        this.leftStream = leftStream;
        this.type = type;
        this.rightStream = rightStream;
        this.onCompare = onCompare;
        this.within = within;
        this.trigger = trigger;
    }

    public Stream getLeftStream() {
        return this.leftStream;
    }

    public Type getType() {
        return this.type;
    }

    public Stream getRightStream() {
        return this.rightStream;
    }

    public Condition getOnCompare() {
        return this.onCompare;
    }

    public EventTrigger getTrigger() {
        return this.trigger;
    }

    public Constant getWithin() {
        return this.within;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (String streamId : this.leftStream.getStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        for (String streamId : this.rightStream.getStreamIds()) {
            if (list.contains(streamId)) continue;
            list.add(streamId);
        }
        return list;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        List<QueryEventStream> queryEventStreamList = this.leftStream.constructQueryEventStreamList(streamDefinitionMap, queryEventStreams);
        return this.rightStream.constructQueryEventStreamList(streamDefinitionMap, queryEventStreamList);
    }

    public static enum Type {
        JOIN,
        INNER_JOIN,
        LEFT_OUTER_JOIN,
        RIGHT_OUTER_JOIN,
        FULL_OUTER_JOIN;

    }

    public static enum EventTrigger {
        LEFT,
        RIGHT,
        ALL;

    }
}

