/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input.sequence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.input.sequence.element.NextElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.OrElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.RegexElement;
import org.wso2.siddhi.query.api.query.input.sequence.element.SequenceElement;

public class SequenceStream
implements Stream,
SequenceElement {
    private SequenceElement sequenceElement;
    private List<String> streamIdList;
    private Constant within;

    public SequenceStream(SequenceElement sequenceElement, Constant within) {
        this.sequenceElement = sequenceElement;
        this.streamIdList = new ArrayList<String>(this.collectStreamIds(sequenceElement, new HashSet<String>()));
        this.within = within;
    }

    public SequenceElement getSequenceElement() {
        return this.sequenceElement;
    }

    @Override
    public List<String> getStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        return this.constructEventStreamList(this.getSequenceElement(), streamDefinitionMap, queryEventStreams);
    }

    private HashSet<String> collectStreamIds(SequenceElement sequenceElement, HashSet<String> streamIds) {
        if (sequenceElement instanceof SequenceStream) {
            streamIds.addAll(((SequenceStream)sequenceElement).getStreamIds());
        } else if (sequenceElement instanceof BasicStream) {
            streamIds.addAll(((BasicStream)sequenceElement).getStreamIds());
        } else if (sequenceElement instanceof OrElement) {
            this.collectStreamIds(((OrElement)sequenceElement).getBasicStream1(), streamIds);
            this.collectStreamIds(((OrElement)sequenceElement).getBasicStream2(), streamIds);
        } else if (sequenceElement instanceof RegexElement) {
            this.collectStreamIds(((RegexElement)sequenceElement).getBasicStream(), streamIds);
        } else if (sequenceElement instanceof NextElement) {
            this.collectStreamIds(((NextElement)sequenceElement).getSequenceElement(), streamIds);
            this.collectStreamIds(((NextElement)sequenceElement).getNextSequenceElement(), streamIds);
        }
        return streamIds;
    }

    public List<QueryEventStream> constructEventStreamList(SequenceElement sequenceElement, Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        if (sequenceElement instanceof BasicStream) {
            ((BasicStream)sequenceElement).constructQueryEventStreamList(streamDefinitionMap, queryEventStreams);
        } else if (sequenceElement instanceof OrElement) {
            this.constructEventStreamList(((OrElement)sequenceElement).getBasicStream1(), streamDefinitionMap, queryEventStreams);
            this.constructEventStreamList(((OrElement)sequenceElement).getBasicStream2(), streamDefinitionMap, queryEventStreams);
        } else if (sequenceElement instanceof RegexElement) {
            this.constructEventStreamList(((RegexElement)sequenceElement).getBasicStream(), streamDefinitionMap, queryEventStreams);
        } else if (sequenceElement instanceof NextElement) {
            this.constructEventStreamList(((NextElement)sequenceElement).getSequenceElement(), streamDefinitionMap, queryEventStreams);
            this.constructEventStreamList(((NextElement)sequenceElement).getNextSequenceElement(), streamDefinitionMap, queryEventStreams);
        } else if (sequenceElement instanceof SequenceStream) {
            ((SequenceStream)sequenceElement).constructQueryEventStreamList(streamDefinitionMap, queryEventStreams);
        }
        return queryEventStreams;
    }

    public Constant getWithin() {
        return this.within;
    }
}

