/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.List;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.exception.MalformedAttributeException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.ExpressionValidator;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.query.QueryEventStream;

public class Compare
extends Condition {
    private Expression rightExpression;
    private Condition.Operator operator;
    private Expression leftExpression;

    public Compare(Expression leftExpression, Condition.Operator operator, Expression rightExpression) {
        this.rightExpression = rightExpression;
        this.operator = operator;
        this.leftExpression = leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public Condition.Operator getOperator() {
        return this.operator;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    @Override
    protected void validate(List<QueryEventStream> queryEventStreamList, String streamReferenceId, boolean processInStreamDefinition) {
        String dataType;
        if (!(!this.operator.equals((Object)Condition.Operator.INSTANCE_OF) || !(this.rightExpression instanceof StringConstant) || (dataType = ((StringConstant)this.rightExpression).getValue()).equalsIgnoreCase(String.class.getSimpleName()) || dataType.equalsIgnoreCase(Integer.class.getSimpleName()) || dataType.equalsIgnoreCase(Double.class.getSimpleName()) || dataType.equalsIgnoreCase(Boolean.class.getSimpleName()) || dataType.equalsIgnoreCase(Long.class.getSimpleName()) || dataType.equalsIgnoreCase(Float.class.getSimpleName()))) {
            throw new MalformedAttributeException("\"" + dataType + "\" is not a valid attribute data type");
        }
        ExpressionValidator.validate(this.rightExpression, queryEventStreamList, streamReferenceId, processInStreamDefinition);
        ExpressionValidator.validate(this.leftExpression, queryEventStreamList, streamReferenceId, processInStreamDefinition);
    }
}

