/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.StreamNotExistException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.FilteredStream;
import org.wso2.siddhi.query.api.query.input.TransformedStream;
import org.wso2.siddhi.query.api.query.input.WindowStream;
import org.wso2.siddhi.query.api.query.input.handler.Filter;
import org.wso2.siddhi.query.api.query.input.handler.Transformer;
import org.wso2.siddhi.query.api.query.input.handler.Window;

public class BasicStream
implements FilteredStream {
    protected String streamId;
    protected StreamDefinition streamDefinition;
    protected String streamReferenceId;
    protected Filter filter = null;
    protected Transformer transformer = null;
    protected boolean isCounterStream = false;
    protected QueryEventStream queryEventStream = null;

    protected BasicStream(String streamId, String streamReferenceId, Filter filter) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
        this.filter = filter;
    }

    protected BasicStream(String streamId) {
        this(streamId, streamId);
    }

    public BasicStream(String streamReferenceId, String streamId) {
        this.streamId = streamId;
        this.streamReferenceId = streamReferenceId;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public void setStreamDefinition(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public BasicStream setStreamReferenceId(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.streamId);
        return list;
    }

    @Override
    public void setCounterStream(boolean counterStream) {
        this.isCounterStream = counterStream;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        this.streamDefinition = streamDefinitionMap.get(this.streamId);
        if (this.streamDefinition == null) {
            throw new StreamNotExistException("Stream definition not exist! No stream defined with stream ID: " + this.streamId);
        }
        this.queryEventStream = new QueryEventStream(this.streamId, this.streamReferenceId, this.streamDefinition, this.filter, this.transformer, null);
        this.queryEventStream.setCounterStream(this.isCounterStream);
        queryEventStreams.add(this.queryEventStream);
        return queryEventStreams;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryEventStream getQueryEventStream() {
        return this.queryEventStream;
    }

    public FilteredStream filter(Condition filterCondition) {
        this.filter = new Filter(filterCondition);
        return this;
    }

    public FilteredStream setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public WindowStream window(String name, Expression ... parameters) {
        return new WindowStream(this, new Window(name, parameters));
    }

    @Override
    public WindowStream window(String namespace, String function, Expression ... parameters) {
        return new WindowStream(this, new Window(namespace, function, parameters));
    }

    @Override
    public WindowStream window(Window window) {
        return new WindowStream(this, window);
    }

    @Override
    public TransformedStream transform(String name, Expression ... parameters) {
        this.transformer = new Transformer(name, parameters);
        return this;
    }

    @Override
    public TransformedStream transform(String extensionName, String functionName, Expression ... parameters) {
        this.transformer = new Transformer(extensionName, functionName, parameters);
        return this;
    }

    @Override
    public TransformedStream setTransformer(Transformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

