/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.definition;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.AttributeAlreadyExistException;
import org.wso2.siddhi.query.api.exception.AttributeNotExistException;

public abstract class AbstractDefinition
implements ExecutionPlan {
    protected String id;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();

    protected void checkAttribute(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            throw new AttributeAlreadyExistException(attributeName + " is already defined for with type " + (Object)((Object)attribute.getType()) + " for " + this.id);
        }
    }

    public List<Attribute> getAttributeList() {
        return this.attributeList;
    }

    public Attribute.Type getAttributeType(String attributeName) {
        for (Attribute attribute : this.attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute.getType();
        }
        throw new AttributeNotExistException("Cannot find attribute type as " + attributeName + " dose not exist");
    }

    public int getAttributePosition(String attributeName) {
        int attributeListSize = this.attributeList.size();
        for (int i = 0; i < attributeListSize; ++i) {
            Attribute attribute = this.attributeList.get(i);
            if (!attribute.getName().equals(attributeName)) continue;
            return i;
        }
        throw new AttributeNotExistException("Cannot get attribute position as " + attributeName + " dose not exist");
    }

    public String[] getAttributeNameArray() {
        int attributeListSize = this.attributeList.size();
        String[] attributeNameArray = new String[attributeListSize];
        for (int i = 0; i < attributeListSize; ++i) {
            attributeNameArray[i] = this.attributeList.get(i).getName();
        }
        return attributeNameArray;
    }

    public String getId() {
        return this.id;
    }
}

