/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.expression;

import java.util.List;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.MalformedAttributeException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventStream;

public class Variable
extends Expression {
    private String streamId;
    private int position = -1;
    private String attributeName;

    public Variable(String streamId, String attributeName) {
        this.streamId = streamId;
        this.attributeName = attributeName;
    }

    public Variable(String attributeName) {
        this.attributeName = attributeName;
    }

    public Variable(String streamId, int position, String attributeName) {
        this.streamId = streamId;
        this.position = position;
        this.attributeName = attributeName;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    protected void validate(List<QueryEventStream> queryEventStreamList, String streamReferenceId, boolean processInStreamDefinition) {
        if (this.streamId == null) {
            this.streamId = streamReferenceId;
        }
        if (this.streamId == null) {
            int occurrences = 0;
            String inputStreamName = "";
            block0: for (QueryEventStream queryEvent : queryEventStreamList) {
                StreamDefinition streamDefinition = processInStreamDefinition ? queryEvent.getInStreamDefinition() : queryEvent.getOutStreamDefinition();
                for (Attribute attribute : streamDefinition.getAttributeList()) {
                    if (!this.getAttributeName().equals(attribute.getName())) continue;
                    ++occurrences;
                    inputStreamName = queryEvent.getStreamId();
                    continue block0;
                }
            }
            if (occurrences == 1) {
                this.streamId = inputStreamName;
            } else {
                if (occurrences > 1) {
                    throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" exists in more than one inputstream.Specify the input stream");
                }
                if (occurrences == 0) {
                    throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" does not exist in " + this.streamId);
                }
            }
        }
        boolean isValid = false;
        block2: for (QueryEventStream queryEvent : queryEventStreamList) {
            if (!queryEvent.getStreamId().equals(this.streamId) && !queryEvent.getReferenceStreamId().equals(this.streamId)) continue;
            StreamDefinition streamDefinition = processInStreamDefinition ? queryEvent.getInStreamDefinition() : queryEvent.getOutStreamDefinition();
            for (Attribute attribute : streamDefinition.getAttributeList()) {
                if (!this.getAttributeName().equals(attribute.getName())) continue;
                isValid = true;
                break block2;
            }
        }
        if (!isValid) {
            throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" does not exist in " + this.streamId);
        }
    }
}

