/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.StreamNotExistException;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.SingleStream;
import org.wso2.siddhi.query.api.query.input.handler.Filter;
import org.wso2.siddhi.query.api.query.input.handler.Transformer;
import org.wso2.siddhi.query.api.query.input.handler.Window;

public class WindowStream
implements SingleStream {
    protected String streamId;
    protected StreamDefinition streamDefinition;
    protected String streamReferenceId;
    protected Filter filter = null;
    protected Window window = null;
    protected Transformer transformer = null;
    protected QueryEventStream queryEventStream = null;

    public WindowStream(BasicStream basicStream, Window window) {
        this.streamId = basicStream.getStreamId();
        this.streamDefinition = basicStream.getStreamDefinition();
        this.streamReferenceId = basicStream.getStreamReferenceId();
        this.filter = basicStream.getFilter();
        this.transformer = basicStream.getTransformer();
        this.window = window;
    }

    public StreamDefinition getStreamDefinition() {
        return this.streamDefinition;
    }

    public void setStreamDefinition(StreamDefinition streamDefinition) {
        this.streamDefinition = streamDefinition;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String getStreamReferenceId() {
        return this.streamReferenceId;
    }

    @Override
    public WindowStream setStreamReferenceId(String streamReferenceId) {
        this.streamReferenceId = streamReferenceId;
        return this;
    }

    @Override
    public List<String> getStreamIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.streamId);
        return list;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        this.streamDefinition = streamDefinitionMap.get(this.streamId);
        if (this.streamDefinition == null) {
            throw new StreamNotExistException("Stream definition not exist! No steam defined with stream ID: " + this.streamId);
        }
        this.queryEventStream = new QueryEventStream(this.streamId, this.streamReferenceId, this.streamDefinition, this.filter, this.transformer, this.window);
        queryEventStreams.add(this.queryEventStream);
        return queryEventStreams;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public QueryEventStream getQueryEventStream() {
        return this.queryEventStream;
    }

    public Window getWindow() {
        return this.window;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }
}

