/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.input.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.expression.constant.Constant;
import org.wso2.siddhi.query.api.query.QueryEventStream;
import org.wso2.siddhi.query.api.query.input.BasicStream;
import org.wso2.siddhi.query.api.query.input.Stream;
import org.wso2.siddhi.query.api.query.input.pattern.element.CountElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.FollowedByElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.LogicalElement;
import org.wso2.siddhi.query.api.query.input.pattern.element.PatternElement;

public class PatternStream
implements Stream,
PatternElement {
    private PatternElement patternElement;
    private List<String> streamIdList;
    private Constant within;

    public PatternStream(PatternElement patternElement, Constant within) {
        this.patternElement = patternElement;
        this.streamIdList = new ArrayList<String>(this.collectStreamIds(patternElement, new HashSet<String>()));
        this.within = within;
    }

    @Override
    public List<String> getStreamIds() {
        return this.streamIdList;
    }

    @Override
    public List<QueryEventStream> constructQueryEventStreamList(Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        return this.constructEventStreamList(this.patternElement, streamDefinitionMap, queryEventStreams);
    }

    public Constant getWithin() {
        return this.within;
    }

    public PatternElement getPatternElement() {
        return this.patternElement;
    }

    private HashSet<String> collectStreamIds(PatternElement patternElement, HashSet<String> streamIds) {
        if (patternElement instanceof PatternStream) {
            streamIds.addAll(((PatternStream)patternElement).getStreamIds());
        } else if (patternElement instanceof BasicStream) {
            streamIds.addAll(((BasicStream)patternElement).getStreamIds());
        } else if (patternElement instanceof LogicalElement) {
            this.collectStreamIds(((LogicalElement)patternElement).getTransformedStream1(), streamIds);
            this.collectStreamIds(((LogicalElement)patternElement).getTransformedStream2(), streamIds);
        } else if (patternElement instanceof CountElement) {
            this.collectStreamIds(((CountElement)patternElement).getTransformedStream(), streamIds);
        } else if (patternElement instanceof FollowedByElement) {
            this.collectStreamIds(((FollowedByElement)patternElement).getPatternElement(), streamIds);
            this.collectStreamIds(((FollowedByElement)patternElement).getFollowedByPatternElement(), streamIds);
        }
        return streamIds;
    }

    public List<QueryEventStream> constructEventStreamList(PatternElement patternElement, Map<String, StreamDefinition> streamDefinitionMap, List<QueryEventStream> queryEventStreams) {
        if (patternElement instanceof BasicStream) {
            ((BasicStream)patternElement).constructQueryEventStreamList(streamDefinitionMap, queryEventStreams);
        } else if (patternElement instanceof LogicalElement) {
            this.constructEventStreamList(((LogicalElement)patternElement).getTransformedStream1(), streamDefinitionMap, queryEventStreams);
            this.constructEventStreamList(((LogicalElement)patternElement).getTransformedStream2(), streamDefinitionMap, queryEventStreams);
        } else if (patternElement instanceof CountElement) {
            this.constructEventStreamList(((CountElement)patternElement).getTransformedStream(), streamDefinitionMap, queryEventStreams);
        } else if (patternElement instanceof FollowedByElement) {
            this.constructEventStreamList(((FollowedByElement)patternElement).getPatternElement(), streamDefinitionMap, queryEventStreams);
            this.constructEventStreamList(((FollowedByElement)patternElement).getFollowedByPatternElement(), streamDefinitionMap, queryEventStreams);
        } else if (patternElement instanceof PatternStream) {
            ((PatternStream)patternElement).constructQueryEventStreamList(streamDefinitionMap, queryEventStreams);
        }
        return queryEventStreams;
    }
}

