/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.query.projection;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.exception.AttributeAlreadyExistException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.Variable;
import org.wso2.siddhi.query.api.query.projection.Call;
import org.wso2.siddhi.query.api.query.projection.attribute.ComplexAttribute;
import org.wso2.siddhi.query.api.query.projection.attribute.OutputAttribute;
import org.wso2.siddhi.query.api.query.projection.attribute.OutputAttributeExtension;
import org.wso2.siddhi.query.api.query.projection.attribute.SimpleAttribute;

public class Projector {
    private List<OutputAttribute> projectionList = new ArrayList<OutputAttribute>();
    private List<Variable> groupByList = new ArrayList<Variable>();
    private Call call;
    private Condition havingCondition;

    public Projector project(String rename, Expression expression) {
        SimpleAttribute outputAttribute = new SimpleAttribute(rename, expression);
        this.checkProjection(outputAttribute);
        this.projectionList.add(outputAttribute);
        return this;
    }

    private void checkProjection(OutputAttribute newAttribute) {
        for (OutputAttribute attribute : this.projectionList) {
            if (!attribute.getRename().equals(newAttribute.getRename())) continue;
            throw new AttributeAlreadyExistException(attribute.getRename() + " is already defined as an output attribute ");
        }
    }

    public Projector project(String rename, String attributeName, Expression ... expressions) {
        ComplexAttribute outputAttribute = new ComplexAttribute(rename, attributeName, expressions);
        this.checkProjection(outputAttribute);
        this.projectionList.add(outputAttribute);
        return this;
    }

    public Projector project(String rename, String extensionNamespace, String extensionFunctionName, Expression ... expressions) {
        OutputAttributeExtension outputAttribute = new OutputAttributeExtension(rename, extensionNamespace, extensionFunctionName, expressions);
        this.checkProjection(outputAttribute);
        this.projectionList.add(outputAttribute);
        return this;
    }

    public Projector having(Condition condition) {
        this.havingCondition = condition;
        return this;
    }

    public Projector groupBy(String streamId, String attributeName) {
        this.groupByList.add(new Variable(streamId, attributeName));
        return this;
    }

    public Projector groupBy(String attributeName) {
        this.groupByList.add(new Variable(attributeName));
        return this;
    }

    public Projector addGroupByList(List<Variable> list) {
        if (list != null) {
            this.groupByList.addAll(list);
        }
        return this;
    }

    public Projector call(String callName, Object ... parameters) {
        this.call = new Call(callName, parameters);
        return this;
    }

    public List<OutputAttribute> getProjectionList() {
        return this.projectionList;
    }

    public List<Variable> getGroupByList() {
        return this.groupByList;
    }

    public Call getCall() {
        return this.call;
    }

    public Condition getHavingCondition() {
        return this.havingCondition;
    }

    public Projector addProjectionList(List<OutputAttribute> projectionList) {
        for (OutputAttribute outputAttribute : projectionList) {
            this.checkProjection(outputAttribute);
            this.projectionList.add(outputAttribute);
        }
        return this;
    }
}

