/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.exception.MalformedAttributeException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.ExpressionValidator;
import org.wso2.siddhi.query.api.expression.constant.StringConstant;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public class Compare
extends Condition {
    private Expression rightExpression;
    private Condition.Operator operator;
    private Expression leftExpression;

    public Compare(Expression leftExpression, Condition.Operator operator, Expression rightExpression) {
        this.rightExpression = rightExpression;
        this.operator = operator;
        this.leftExpression = leftExpression;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public Condition.Operator getOperator() {
        return this.operator;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    @Override
    protected void validate(List<QueryEventSource> queryEventSourceList, ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, String streamReferenceId, boolean processInStreamDefinition) {
        String dataType;
        if (!(!this.operator.equals((Object)Condition.Operator.INSTANCE_OF) || !(this.rightExpression instanceof StringConstant) || (dataType = ((StringConstant)this.rightExpression).getValue()).equalsIgnoreCase(String.class.getSimpleName()) || dataType.equalsIgnoreCase(Integer.class.getSimpleName()) || dataType.equalsIgnoreCase(Double.class.getSimpleName()) || dataType.equalsIgnoreCase(Boolean.class.getSimpleName()) || dataType.equalsIgnoreCase(Long.class.getSimpleName()) || dataType.equalsIgnoreCase(Float.class.getSimpleName()))) {
            throw new MalformedAttributeException("\"" + dataType + "\" is not a valid attribute data type");
        }
        ExpressionValidator.validate(this.rightExpression, queryEventSourceList, streamReferenceId, processInStreamDefinition);
        ExpressionValidator.validate(this.leftExpression, queryEventSourceList, streamReferenceId, processInStreamDefinition);
    }

    public String toString() {
        return "Compare{rightExpression=" + this.rightExpression + ", operator=" + (Object)((Object)this.operator) + ", leftExpression=" + this.leftExpression + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Compare compare = (Compare)o;
        if (this.leftExpression != null ? !this.leftExpression.equals(compare.leftExpression) : compare.leftExpression != null) {
            return false;
        }
        if (this.operator != compare.operator) {
            return false;
        }
        return !(this.rightExpression != null ? !this.rightExpression.equals(compare.rightExpression) : compare.rightExpression != null);
    }

    public int hashCode() {
        int result = this.rightExpression != null ? this.rightExpression.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.leftExpression != null ? this.leftExpression.hashCode() : 0);
        return result;
    }

    @Override
    public Set<String> getDependencySet() {
        Set<String> dependencySet = ExpressionValidator.getDependencySet(this.leftExpression);
        dependencySet.addAll(ExpressionValidator.getDependencySet(this.rightExpression));
        return dependencySet;
    }
}

