/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.condition.AndCondition;
import org.wso2.siddhi.query.api.condition.BooleanCondition;
import org.wso2.siddhi.query.api.condition.Compare;
import org.wso2.siddhi.query.api.condition.ConditionExtension;
import org.wso2.siddhi.query.api.condition.FunctionCondition;
import org.wso2.siddhi.query.api.condition.InCondition;
import org.wso2.siddhi.query.api.condition.NotCondition;
import org.wso2.siddhi.query.api.condition.OrCondition;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public abstract class Condition {
    public static Condition compare(Expression leftExpression, Operator operator, Expression rightExpression) {
        return new Compare(leftExpression, operator, rightExpression);
    }

    public static Condition in(Condition leftCondition, String streamId) {
        return new InCondition(leftCondition, streamId);
    }

    public static Condition and(Condition leftCondition, Condition rightCondition) {
        return new AndCondition(leftCondition, rightCondition);
    }

    public static Condition or(Condition leftCondition, Condition rightCondition) {
        return new OrCondition(leftCondition, rightCondition);
    }

    public static Condition not(Condition condition) {
        return new NotCondition(condition);
    }

    public static Condition bool(Expression expression) {
        return new BooleanCondition(expression);
    }

    public static Condition extension(String extensionNamespace, String extensionFunctionName, Expression ... expressions) {
        return new ConditionExtension(extensionNamespace, extensionFunctionName, expressions);
    }

    public static Condition function(String extensionFunctionName, Expression ... expressions) {
        return new FunctionCondition(extensionFunctionName, expressions);
    }

    protected abstract void validate(List<QueryEventSource> var1, ConcurrentMap<String, AbstractDefinition> var2, String var3, boolean var4);

    protected Set<String> getDependencySet() {
        return new HashSet<String>();
    }

    public static enum Operator {
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_EQUAL,
        GREATER_THAN_EQUAL,
        EQUAL,
        NOT_EQUAL,
        CONTAINS,
        INSTANCE_OF;

    }
}

