/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.expression.ExpressionValidator;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public class FunctionCondition
extends Condition {
    protected String functionName;
    protected Expression[] parameters;

    public FunctionCondition(String functionName, Expression[] parameters) {
        this.functionName = functionName;
        this.parameters = parameters;
    }

    public String getFunction() {
        return this.functionName;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Expression[] parameters) {
        this.parameters = parameters;
    }

    @Override
    protected void validate(List<QueryEventSource> queryEventSourceList, ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, String streamReferenceId, boolean processInStreamDefinition) {
        for (Expression expression : this.parameters) {
            ExpressionValidator.validate(expression, queryEventSourceList, streamReferenceId, processInStreamDefinition);
        }
    }

    public String toString() {
        return "ConditionFunction{functionName='" + this.functionName + '\'' + ", parameters=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCondition that = (FunctionCondition)o;
        if (!this.functionName.equals(that.functionName)) {
            return false;
        }
        return Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.functionName.hashCode();
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        return result;
    }

    @Override
    protected Set<String> getDependencySet() {
        HashSet<String> dependencySet = new HashSet<String>();
        for (Expression expression : this.parameters) {
            dependencySet.addAll(ExpressionValidator.getDependencySet(expression));
        }
        return dependencySet;
    }
}

