/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.condition;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.TableDefinition;
import org.wso2.siddhi.query.api.exception.SourceNotExistException;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public class InCondition
extends Condition {
    private Condition condition;
    private String sourceId;

    public InCondition(Condition condition, String sourceId) {
        this.condition = condition;
        this.sourceId = sourceId;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    protected void validate(List<QueryEventSource> queryEventSourceList, ConcurrentMap<String, AbstractDefinition> streamTableDefinitionMap, String streamReferenceId, boolean processInStreamDefinition) {
        AbstractDefinition definition = (AbstractDefinition)streamTableDefinitionMap.get(this.sourceId);
        if (definition == null) {
            throw new SourceNotExistException("Event Table with name '" + this.sourceId + "' not defined in Siddhi");
        }
        if (!(definition instanceof TableDefinition)) {
            throw new SourceNotExistException(this.sourceId + " is not an Event Table");
        }
        queryEventSourceList.add(new QueryEventSource(this.sourceId, this.sourceId, definition, null, null, null));
        this.condition.validate(queryEventSourceList, streamTableDefinitionMap, streamReferenceId, processInStreamDefinition);
        queryEventSourceList.remove(queryEventSourceList.size() - 1);
    }

    public String toString() {
        return "InCondition{condition='" + this.condition + '\'' + ", sourceId=" + this.sourceId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InCondition that = (InCondition)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        return !(this.sourceId != null ? !this.sourceId.equals(that.sourceId) : that.sourceId != null);
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
        return result;
    }

    @Override
    public Set<String> getDependencySet() {
        return this.condition.getDependencySet();
    }
}

