/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.definition.partition;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.query.api.ExecutionPlan;
import org.wso2.siddhi.query.api.condition.Condition;
import org.wso2.siddhi.query.api.definition.partition.PartitionType;
import org.wso2.siddhi.query.api.definition.partition.RangePartitionType;
import org.wso2.siddhi.query.api.definition.partition.VariablePartitionType;
import org.wso2.siddhi.query.api.expression.Variable;

public class PartitionDefinition
implements ExecutionPlan {
    private String partitionId;
    private List<PartitionType> partitionTypeList = new ArrayList<PartitionType>();

    public PartitionDefinition name(String name) {
        this.partitionId = name;
        return this;
    }

    public PartitionDefinition partitionBy(Variable variable) {
        this.partitionTypeList.add(new VariablePartitionType(variable));
        return this;
    }

    public PartitionDefinition partitionBy(Condition condition, String label) {
        this.partitionTypeList.add(new RangePartitionType(condition, label));
        return this;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void addPartitionType(PartitionType partitionType) {
        this.partitionTypeList.add(partitionType);
    }

    public List<PartitionType> getPartitionTypeList() {
        return this.partitionTypeList;
    }

    public String toString() {
        return "PartitionDefinition{partitionId='" + this.partitionId + '\'' + ", partitionTypeList=" + this.partitionTypeList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionDefinition that = (PartitionDefinition)o;
        if (this.partitionId != null ? !this.partitionId.equals(that.partitionId) : that.partitionId != null) {
            return false;
        }
        return !(this.partitionTypeList != null ? !((Object)this.partitionTypeList).equals(that.partitionTypeList) : that.partitionTypeList != null);
    }

    public int hashCode() {
        int result = this.partitionId != null ? this.partitionId.hashCode() : 0;
        result = 31 * result + (this.partitionTypeList != null ? ((Object)this.partitionTypeList).hashCode() : 0);
        return result;
    }
}

