/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.expression;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public class FunctionExpression
extends Expression {
    protected String functionName;
    protected Expression[] parameters;

    public FunctionExpression(String functionName, Expression ... parameters) {
        this.functionName = functionName;
        this.parameters = parameters;
    }

    public String getFunction() {
        return this.functionName;
    }

    public void setParameters(Expression[] parameters) {
        this.parameters = parameters;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }

    @Override
    protected void validate(List<QueryEventSource> queryEventSources, String streamReferenceId, boolean processInStreamDefinition) {
        for (Expression expression : this.parameters) {
            expression.validate(queryEventSources, streamReferenceId, processInStreamDefinition);
        }
    }

    public String toString() {
        return "ExpressionFunction{, functionName='" + this.functionName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionExpression that = (FunctionExpression)o;
        if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) {
            return false;
        }
        return Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.functionName != null ? this.functionName.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        return result;
    }

    @Override
    protected Set<String> getDependencySet() {
        HashSet<String> dependencySet = new HashSet<String>();
        for (Expression expression : this.parameters) {
            dependencySet.addAll(expression.getDependencySet());
        }
        return dependencySet;
    }
}

