/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.query.api.expression;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.MalformedAttributeException;
import org.wso2.siddhi.query.api.expression.Expression;
import org.wso2.siddhi.query.api.query.QueryEventSource;

public class Variable
extends Expression {
    private String streamId;
    private int position = -1;
    private String attributeName;

    public Variable(String streamId, String attributeName) {
        this.streamId = streamId;
        this.attributeName = attributeName;
    }

    public Variable(String attributeName) {
        this.attributeName = attributeName;
    }

    public Variable(String streamId, int position, String attributeName) {
        this.streamId = streamId;
        this.position = position;
        this.attributeName = attributeName;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    protected void validate(List<QueryEventSource> queryEventSourceList, String streamReferenceId, boolean processInStreamDefinition) {
        if (this.streamId == null) {
            this.streamId = streamReferenceId;
        }
        if (this.streamId == null) {
            int occurrences = 0;
            String inputStreamName = "";
            block0: for (QueryEventSource queryEvent : queryEventSourceList) {
                AbstractDefinition definition = processInStreamDefinition ? queryEvent.getInDefinition() : queryEvent.getOutDefinition();
                for (Attribute attribute : definition.getAttributeList()) {
                    if (!this.getAttributeName().equals(attribute.getName())) continue;
                    ++occurrences;
                    inputStreamName = queryEvent.getSourceId();
                    continue block0;
                }
            }
            if (occurrences == 1) {
                this.streamId = inputStreamName;
            } else {
                if (occurrences > 1) {
                    throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" exists in more than one inputstream.Specify the input stream");
                }
                if (occurrences == 0) {
                    if (null != queryEventSourceList && queryEventSourceList.size() == 1) {
                        throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" does not exist in " + queryEventSourceList.get(0).getSourceId());
                    }
                    throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" does not exist");
                }
            }
        }
        boolean isValid = false;
        block2: for (QueryEventSource queryEvent : queryEventSourceList) {
            if (!queryEvent.getSourceId().equals(this.streamId) && !queryEvent.getReferenceSourceId().equals(this.streamId)) continue;
            AbstractDefinition definition = processInStreamDefinition ? queryEvent.getInDefinition() : queryEvent.getOutDefinition();
            for (Attribute attribute : definition.getAttributeList()) {
                if (!this.getAttributeName().equals(attribute.getName())) continue;
                isValid = true;
                break block2;
            }
        }
        if (!isValid) {
            throw new MalformedAttributeException("Attribute \"" + this.getAttributeName() + "\" does not exist in " + this.streamId);
        }
    }

    public String toString() {
        return "Variable {streamId='" + this.streamId + '\'' + ", position=" + this.position + ", attributeName=" + this.attributeName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable variable = (Variable)o;
        if (this.position != variable.position) {
            return false;
        }
        if (!this.attributeName.equals(variable.attributeName)) {
            return false;
        }
        return !(this.streamId != null ? !this.streamId.equals(variable.streamId) : variable.streamId != null);
    }

    public int hashCode() {
        int result = this.streamId != null ? this.streamId.hashCode() : 0;
        result = 31 * result + this.position;
        result = 31 * result + this.attributeName.hashCode();
        return result;
    }

    @Override
    public Set<String> getDependencySet() {
        HashSet<String> dependencySet = new HashSet<String>();
        if (this.streamId != null && !this.streamId.isEmpty()) {
            dependencySet.add(this.streamId);
        }
        return dependencySet;
    }
}

